/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.sun.jersey.core.impl.provider.header;

import io.hops.hadoop.shaded.com.sun.jersey.core.header.reader.HttpHeaderReader;
import io.hops.hadoop.shaded.com.sun.jersey.core.impl.provider.header.WriterUtil;
import io.hops.hadoop.shaded.com.sun.jersey.spi.HeaderDelegateProvider;
import io.hops.hadoop.shaded.javax.ws.rs.core.EntityTag;
import java.text.ParseException;

public class EntityTagProvider
implements HeaderDelegateProvider<EntityTag> {
    @Override
    public boolean supports(Class<?> type) {
        return type == EntityTag.class;
    }

    @Override
    public String toString(EntityTag header) {
        StringBuilder b = new StringBuilder();
        if (header.isWeak()) {
            b.append("W/");
        }
        WriterUtil.appendQuoted(b, header.getValue());
        return b.toString();
    }

    @Override
    public EntityTag fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("Entity tag is null");
        }
        try {
            HttpHeaderReader reader = HttpHeaderReader.newInstance(header);
            HttpHeaderReader.Event e = reader.next(false);
            if (e == HttpHeaderReader.Event.QuotedString) {
                return new EntityTag(reader.getEventValue());
            }
            if (e == HttpHeaderReader.Event.Token && reader.getEventValue().equals("W")) {
                reader.nextSeparator('/');
                return new EntityTag(reader.nextQuotedString(), true);
            }
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing entity tag '" + header + "'", ex);
        }
        throw new IllegalArgumentException("Error parsing entity tag '" + header + "'");
    }
}

