/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.curator.framework.recipes.locks;

import io.hops.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.locks.InterProcessLock;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import io.hops.hadoop.shaded.org.apache.curator.framework.recipes.locks.Lease;
import io.hops.hadoop.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public class InterProcessSemaphoreMutex
implements InterProcessLock {
    private final InterProcessSemaphoreV2 semaphore;
    private volatile Lease lease;

    public InterProcessSemaphoreMutex(CuratorFramework client, String path) {
        this.semaphore = new InterProcessSemaphoreV2(client, path, 1);
    }

    @Override
    public void acquire() throws Exception {
        this.lease = this.semaphore.acquire();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) throws Exception {
        Lease acquiredLease = this.semaphore.acquire(time, unit);
        if (acquiredLease == null) {
            return false;
        }
        this.lease = acquiredLease;
        return true;
    }

    @Override
    public void release() throws Exception {
        Lease lease = this.lease;
        Preconditions.checkState(lease != null, "Not acquired");
        this.lease = null;
        lease.close();
    }

    @Override
    public boolean isAcquiredInThisProcess() {
        return this.lease != null;
    }
}

