/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.http.impl.cookie;

import io.hops.hadoop.shaded.org.apache.http.annotation.Immutable;
import io.hops.hadoop.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.hops.hadoop.shaded.org.apache.http.cookie.Cookie;
import io.hops.hadoop.shaded.org.apache.http.cookie.CookieOrigin;
import io.hops.hadoop.shaded.org.apache.http.cookie.MalformedCookieException;
import io.hops.hadoop.shaded.org.apache.http.cookie.SetCookie;
import io.hops.hadoop.shaded.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import io.hops.hadoop.shaded.org.apache.http.util.Args;

@Immutable
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

