/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.xbill.DNS;

import io.hops.hadoop.shaded.org.xbill.DNS.DClass;
import io.hops.hadoop.shaded.org.xbill.DNS.Message;
import io.hops.hadoop.shaded.org.xbill.DNS.Name;
import io.hops.hadoop.shaded.org.xbill.DNS.NameTooLongException;
import io.hops.hadoop.shaded.org.xbill.DNS.Options;
import io.hops.hadoop.shaded.org.xbill.DNS.Rcode;
import io.hops.hadoop.shaded.org.xbill.DNS.Record;
import io.hops.hadoop.shaded.org.xbill.DNS.SOARecord;
import io.hops.hadoop.shaded.org.xbill.DNS.Serial;
import io.hops.hadoop.shaded.org.xbill.DNS.TCPClient;
import io.hops.hadoop.shaded.org.xbill.DNS.TSIG;
import io.hops.hadoop.shaded.org.xbill.DNS.TSIGRecord;
import io.hops.hadoop.shaded.org.xbill.DNS.WireParseException;
import io.hops.hadoop.shaded.org.xbill.DNS.ZoneTransferException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class ZoneTransferIn {
    private static final int INITIALSOA = 0;
    private static final int FIRSTDATA = 1;
    private static final int IXFR_DELSOA = 2;
    private static final int IXFR_DEL = 3;
    private static final int IXFR_ADDSOA = 4;
    private static final int IXFR_ADD = 5;
    private static final int AXFR = 6;
    private static final int END = 7;
    private Name zname;
    private int qtype;
    private int dclass;
    private long ixfr_serial;
    private boolean want_fallback;
    private ZoneTransferHandler handler;
    private SocketAddress localAddress;
    private SocketAddress address;
    private TCPClient client;
    private TSIG tsig;
    private TSIG.StreamVerifier verifier;
    private long timeout = 900000L;
    private int state;
    private long end_serial;
    private long current_serial;
    private Record initialsoa;
    private int rtype;

    private ZoneTransferIn() {
    }

    private ZoneTransferIn(Name zone, int xfrtype, long serial, boolean fallback, SocketAddress address, TSIG key) {
        this.address = address;
        this.tsig = key;
        if (zone.isAbsolute()) {
            this.zname = zone;
        } else {
            try {
                this.zname = Name.concatenate(zone, Name.root);
            }
            catch (NameTooLongException e) {
                throw new IllegalArgumentException("ZoneTransferIn: name too long");
            }
        }
        this.qtype = xfrtype;
        this.dclass = 1;
        this.ixfr_serial = serial;
        this.want_fallback = fallback;
        this.state = 0;
    }

    public static ZoneTransferIn newAXFR(Name zone, SocketAddress address, TSIG key) {
        return new ZoneTransferIn(zone, 252, 0L, false, address, key);
    }

    public static ZoneTransferIn newAXFR(Name zone, String host, int port, TSIG key) throws UnknownHostException {
        if (port == 0) {
            port = 53;
        }
        return ZoneTransferIn.newAXFR(zone, new InetSocketAddress(host, port), key);
    }

    public static ZoneTransferIn newAXFR(Name zone, String host, TSIG key) throws UnknownHostException {
        return ZoneTransferIn.newAXFR(zone, host, 0, key);
    }

    public static ZoneTransferIn newIXFR(Name zone, long serial, boolean fallback, SocketAddress address, TSIG key) {
        return new ZoneTransferIn(zone, 251, serial, fallback, address, key);
    }

    public static ZoneTransferIn newIXFR(Name zone, long serial, boolean fallback, String host, int port, TSIG key) throws UnknownHostException {
        if (port == 0) {
            port = 53;
        }
        return ZoneTransferIn.newIXFR(zone, serial, fallback, new InetSocketAddress(host, port), key);
    }

    public static ZoneTransferIn newIXFR(Name zone, long serial, boolean fallback, String host, TSIG key) throws UnknownHostException {
        return ZoneTransferIn.newIXFR(zone, serial, fallback, host, 0, key);
    }

    public Name getName() {
        return this.zname;
    }

    public int getType() {
        return this.qtype;
    }

    public void setTimeout(int secs) {
        if (secs < 0) {
            throw new IllegalArgumentException("timeout cannot be negative");
        }
        this.timeout = 1000L * (long)secs;
    }

    public void setDClass(int dclass) {
        DClass.check(dclass);
        this.dclass = dclass;
    }

    public void setLocalAddress(SocketAddress addr) {
        this.localAddress = addr;
    }

    private void openConnection() throws IOException {
        long endTime = System.currentTimeMillis() + this.timeout;
        this.client = new TCPClient(endTime);
        if (this.localAddress != null) {
            this.client.bind(this.localAddress);
        }
        this.client.connect(this.address);
    }

    private void sendQuery() throws IOException {
        Record question = Record.newRecord(this.zname, this.qtype, this.dclass);
        Message query = new Message();
        query.getHeader().setOpcode(0);
        query.addRecord(question, 0);
        if (this.qtype == 251) {
            SOARecord soa = new SOARecord(this.zname, this.dclass, 0L, Name.root, Name.root, this.ixfr_serial, 0L, 0L, 0L, 0L);
            query.addRecord(soa, 2);
        }
        if (this.tsig != null) {
            this.tsig.apply(query, null);
            this.verifier = new TSIG.StreamVerifier(this.tsig, query.getTSIG());
        }
        byte[] out = query.toWire(65535);
        this.client.send(out);
    }

    private static long getSOASerial(Record rec) {
        SOARecord soa = (SOARecord)rec;
        return soa.getSerial();
    }

    private void logxfr(String s2) {
        if (Options.check("verbose")) {
            System.out.println(this.zname + ": " + s2);
        }
    }

    private void fail(String s2) throws ZoneTransferException {
        throw new ZoneTransferException(s2);
    }

    private void fallback() throws ZoneTransferException {
        if (!this.want_fallback) {
            this.fail("server doesn't support IXFR");
        }
        this.logxfr("falling back to AXFR");
        this.qtype = 252;
        this.state = 0;
    }

    private void parseRR(Record rec) throws ZoneTransferException {
        int type = rec.getType();
        switch (this.state) {
            case 0: {
                if (type != 6) {
                    this.fail("missing initial SOA");
                }
                this.initialsoa = rec;
                this.end_serial = ZoneTransferIn.getSOASerial(rec);
                if (this.qtype == 251 && Serial.compare(this.end_serial, this.ixfr_serial) <= 0) {
                    this.logxfr("up to date");
                    this.state = 7;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (this.qtype == 251 && type == 6 && ZoneTransferIn.getSOASerial(rec) == this.ixfr_serial) {
                    this.rtype = 251;
                    this.handler.startIXFR();
                    this.logxfr("got incremental response");
                    this.state = 2;
                } else {
                    this.rtype = 252;
                    this.handler.startAXFR();
                    this.handler.handleRecord(this.initialsoa);
                    this.logxfr("got nonincremental response");
                    this.state = 6;
                }
                this.parseRR(rec);
                return;
            }
            case 2: {
                this.handler.startIXFRDeletes(rec);
                this.state = 3;
                break;
            }
            case 3: {
                if (type == 6) {
                    this.current_serial = ZoneTransferIn.getSOASerial(rec);
                    this.state = 4;
                    this.parseRR(rec);
                    return;
                }
                this.handler.handleRecord(rec);
                break;
            }
            case 4: {
                this.handler.startIXFRAdds(rec);
                this.state = 5;
                break;
            }
            case 5: {
                if (type == 6) {
                    long soa_serial = ZoneTransferIn.getSOASerial(rec);
                    if (soa_serial == this.end_serial) {
                        this.state = 7;
                        break;
                    }
                    if (soa_serial != this.current_serial) {
                        this.fail("IXFR out of sync: expected serial " + this.current_serial + " , got " + soa_serial);
                    } else {
                        this.state = 2;
                        this.parseRR(rec);
                        return;
                    }
                }
                this.handler.handleRecord(rec);
                break;
            }
            case 6: {
                if (type == 1 && rec.getDClass() != this.dclass) break;
                this.handler.handleRecord(rec);
                if (type != 6) break;
                this.state = 7;
                break;
            }
            case 7: {
                this.fail("extra data");
                break;
            }
            default: {
                this.fail("invalid state");
            }
        }
    }

    private void closeConnection() {
        try {
            if (this.client != null) {
                this.client.cleanup();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Message parseMessage(byte[] b) throws WireParseException {
        try {
            return new Message(b);
        }
        catch (IOException e) {
            if (e instanceof WireParseException) {
                throw (WireParseException)e;
            }
            throw new WireParseException("Error parsing message");
        }
    }

    private void doxfr() throws IOException, ZoneTransferException {
        this.sendQuery();
        while (this.state != 7) {
            byte[] in = this.client.recv();
            Message response = this.parseMessage(in);
            if (response.getHeader().getRcode() == 0 && this.verifier != null) {
                TSIGRecord tsigrec = response.getTSIG();
                int error = this.verifier.verify(response, in);
                if (error != 0) {
                    this.fail("TSIG failure");
                }
            }
            Record[] answers = response.getSectionArray(1);
            if (this.state == 0) {
                Record question;
                int rcode = response.getRcode();
                if (rcode != 0) {
                    if (this.qtype == 251 && rcode == 4) {
                        this.fallback();
                        this.doxfr();
                        return;
                    }
                    this.fail(Rcode.string(rcode));
                }
                if ((question = response.getQuestion()) != null && question.getType() != this.qtype) {
                    this.fail("invalid question section");
                }
                if (answers.length == 0 && this.qtype == 251) {
                    this.fallback();
                    this.doxfr();
                    return;
                }
            }
            for (int i = 0; i < answers.length; ++i) {
                this.parseRR(answers[i]);
            }
            if (this.state != 7 || this.verifier == null || response.isVerified()) continue;
            this.fail("last message must be signed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ZoneTransferHandler handler) throws IOException, ZoneTransferException {
        this.handler = handler;
        try {
            this.openConnection();
            this.doxfr();
        }
        finally {
            this.closeConnection();
        }
    }

    public List run() throws IOException, ZoneTransferException {
        BasicHandler handler = new BasicHandler();
        this.run(handler);
        if (handler.axfr != null) {
            return handler.axfr;
        }
        return handler.ixfr;
    }

    private BasicHandler getBasicHandler() throws IllegalArgumentException {
        if (this.handler instanceof BasicHandler) {
            return (BasicHandler)this.handler;
        }
        throw new IllegalArgumentException("ZoneTransferIn used callback interface");
    }

    public boolean isAXFR() {
        return this.rtype == 252;
    }

    public List getAXFR() {
        BasicHandler handler = this.getBasicHandler();
        return handler.axfr;
    }

    public boolean isIXFR() {
        return this.rtype == 251;
    }

    public List getIXFR() {
        BasicHandler handler = this.getBasicHandler();
        return handler.ixfr;
    }

    public boolean isCurrent() {
        BasicHandler handler = this.getBasicHandler();
        return handler.axfr == null && handler.ixfr == null;
    }

    private static class BasicHandler
    implements ZoneTransferHandler {
        private List axfr;
        private List ixfr;

        private BasicHandler() {
        }

        public void startAXFR() {
            this.axfr = new ArrayList();
        }

        public void startIXFR() {
            this.ixfr = new ArrayList();
        }

        public void startIXFRDeletes(Record soa) {
            Delta delta = new Delta();
            delta.deletes.add(soa);
            delta.start = ZoneTransferIn.getSOASerial(soa);
            this.ixfr.add(delta);
        }

        public void startIXFRAdds(Record soa) {
            Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
            delta.adds.add(soa);
            delta.end = ZoneTransferIn.getSOASerial(soa);
        }

        public void handleRecord(Record r) {
            List list;
            if (this.ixfr != null) {
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                list = delta.adds.size() > 0 ? delta.adds : delta.deletes;
            } else {
                list = this.axfr;
            }
            list.add(r);
        }
    }

    public static interface ZoneTransferHandler {
        public void startAXFR() throws ZoneTransferException;

        public void startIXFR() throws ZoneTransferException;

        public void startIXFRDeletes(Record var1) throws ZoneTransferException;

        public void startIXFRAdds(Record var1) throws ZoneTransferException;

        public void handleRecord(Record var1) throws ZoneTransferException;
    }

    public static class Delta {
        public long start;
        public long end;
        public List adds = new ArrayList();
        public List deletes = new ArrayList();

        private Delta() {
        }
    }
}

