/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul;

import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.google.common.collect.ImmutableMap;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.BaseClient;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.config.ClientConfig;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.session.Session;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.session.SessionCreatedResponse;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.model.session.SessionInfo;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.com.orbitz.consul.monitoring.ClientEventCallback;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Call;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.Retrofit;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.Body;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.GET;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.PUT;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.Path;
import io.hops.hadoop.shaded.com.logicalclocks.shaded.retrofit2.http.QueryMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SessionClient
extends BaseClient {
    private static String CLIENT_NAME = "session";
    private final Api api;

    SessionClient(Retrofit retrofit, ClientConfig config, ClientEventCallback eventCallback) {
        super(CLIENT_NAME, config, eventCallback);
        this.api = retrofit.create(Api.class);
    }

    public SessionCreatedResponse createSession(Session value) {
        return this.createSession(value, null);
    }

    public SessionCreatedResponse createSession(Session value, String dc) {
        return this.http.extract(this.api.createSession(value, this.dcQuery(dc)), new Integer[0]);
    }

    private Map<String, String> dcQuery(String dc) {
        return dc != null ? ImmutableMap.of("dc", dc) : Collections.emptyMap();
    }

    public Optional<SessionInfo> renewSession(String sessionId) {
        return this.renewSession(null, sessionId);
    }

    public Optional<SessionInfo> renewSession(String dc, String sessionId) {
        List<SessionInfo> sessionInfo = this.http.extract(this.api.renewSession(sessionId, ImmutableMap.of(), this.dcQuery(dc)), new Integer[0]);
        return sessionInfo == null || sessionInfo.isEmpty() ? Optional.empty() : Optional.of(sessionInfo.get(0));
    }

    public void destroySession(String sessionId) {
        this.destroySession(sessionId, null);
    }

    public void destroySession(String sessionId, String dc) {
        this.http.handle(this.api.destroySession(sessionId, this.dcQuery(dc)), new Integer[0]);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId) {
        return this.getSessionInfo(sessionId, null);
    }

    public Optional<SessionInfo> getSessionInfo(String sessionId, String dc) {
        List<SessionInfo> sessionInfo = this.http.extract(this.api.getSessionInfo(sessionId, this.dcQuery(dc)), new Integer[0]);
        return sessionInfo == null || sessionInfo.isEmpty() ? Optional.empty() : Optional.of(sessionInfo.get(0));
    }

    public List<SessionInfo> listSessions(String dc) {
        return this.http.extract(this.api.listSessions(this.dcQuery(dc)), new Integer[0]);
    }

    public List<SessionInfo> listSessions() {
        return this.listSessions(null);
    }

    static interface Api {
        @PUT(value="session/create")
        public Call<SessionCreatedResponse> createSession(@Body Session var1, @QueryMap Map<String, String> var2);

        @PUT(value="session/renew/{sessionId}")
        public Call<List<SessionInfo>> renewSession(@Path(value="sessionId") String var1, @Body Map<String, String> var2, @QueryMap Map<String, String> var3);

        @PUT(value="session/destroy/{sessionId}")
        public Call<Void> destroySession(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/info/{sessionId}")
        public Call<List<SessionInfo>> getSessionInfo(@Path(value="sessionId") String var1, @QueryMap Map<String, String> var2);

        @GET(value="session/list")
        public Call<List<SessionInfo>> listSessions(@QueryMap Map<String, String> var1);
    }
}

