/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.com.nimbusds.jose.util;

import io.hops.hadoop.shaded.com.nimbusds.jose.util.RestrictedResourceRetriever;
import io.hops.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private int connectTimeout;
    private int readTimeout;
    private int sizeLimit;

    public AbstractRestrictedResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit) {
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
        this.setSizeLimit(sizeLimit);
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeoutMs) {
        if (connectTimeoutMs < 0) {
            throw new IllegalArgumentException("The connect timeout must not be negative");
        }
        this.connectTimeout = connectTimeoutMs;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeoutMs) {
        if (readTimeoutMs < 0) {
            throw new IllegalArgumentException("The read timeout must not be negative");
        }
        this.readTimeout = readTimeoutMs;
    }

    @Override
    public int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public void setSizeLimit(int sizeLimitBytes) {
        if (sizeLimitBytes < 0) {
            throw new IllegalArgumentException("The size limit must not be negative");
        }
        this.sizeLimit = sizeLimitBytes;
    }
}

