/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.http.client.protocol;

import io.hops.hadoop.shaded.org.apache.http.HttpEntity;
import io.hops.hadoop.shaded.org.apache.http.HttpEntityEnclosingRequest;
import io.hops.hadoop.shaded.org.apache.http.HttpException;
import io.hops.hadoop.shaded.org.apache.http.HttpRequest;
import io.hops.hadoop.shaded.org.apache.http.HttpRequestInterceptor;
import io.hops.hadoop.shaded.org.apache.http.HttpVersion;
import io.hops.hadoop.shaded.org.apache.http.ProtocolVersion;
import io.hops.hadoop.shaded.org.apache.http.annotation.Immutable;
import io.hops.hadoop.shaded.org.apache.http.client.config.RequestConfig;
import io.hops.hadoop.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.hops.hadoop.shaded.org.apache.http.protocol.HttpContext;
import io.hops.hadoop.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

