/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request;

import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.client.request.TgsRequest;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.CheckSumUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApOptions;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ap.Authenticator;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.KrbTicket;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.SgtTicket;
import io.hops.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;

public class TgsRequestWithTgt
extends TgsRequest {
    private ApReq apReq;
    private KrbTicket ticket;
    private PrincipalName clientPrincipal;

    public TgsRequestWithTgt(KrbContext context, TgtTicket tgt) {
        super(context);
        this.setAllowedPreauth(PaDataType.TGS_REQ);
        this.ticket = tgt;
        this.clientPrincipal = tgt.getClientPrincipal();
        if (this.clientPrincipal.getRealm() == null) {
            this.clientPrincipal.setRealm(tgt.getRealm());
        }
    }

    public TgsRequestWithTgt(KrbContext context, SgtTicket sgt) {
        super(context);
        this.setAllowedPreauth(PaDataType.TGS_REQ);
        this.ticket = sgt;
        this.clientPrincipal = sgt.getClientPrincipal();
        if (this.clientPrincipal.getRealm() == null) {
            this.clientPrincipal.setRealm(sgt.getRealm());
        }
    }

    @Override
    public PrincipalName getClientPrincipal() {
        return this.clientPrincipal;
    }

    @Override
    public EncryptionKey getClientKey() throws KrbException {
        return this.getSessionKey();
    }

    @Override
    public EncryptionKey getSessionKey() {
        return this.ticket.getSessionKey();
    }

    private ApReq makeApReq() throws KrbException {
        ApReq apReq = new ApReq();
        Authenticator authenticator = this.makeAuthenticator();
        EncryptionKey sessionKey = this.ticket.getSessionKey();
        EncryptedData authnData = EncryptionUtil.seal(authenticator, sessionKey, KeyUsage.TGS_REQ_AUTH);
        apReq.setEncryptedAuthenticator(authnData);
        apReq.setAuthenticator(authenticator);
        apReq.setTicket(this.ticket.getTicket());
        ApOptions apOptions = new ApOptions();
        apReq.setApOptions(apOptions);
        return apReq;
    }

    public ApReq getApReq() throws KrbException {
        if (this.apReq == null) {
            this.apReq = this.makeApReq();
        }
        return this.apReq;
    }

    private Authenticator makeAuthenticator() throws KrbException {
        Authenticator authenticator = new Authenticator();
        authenticator.setAuthenticatorVno(5);
        authenticator.setCname(this.clientPrincipal);
        authenticator.setCrealm(this.clientPrincipal.getRealm());
        authenticator.setCtime(KerberosTime.now());
        authenticator.setCusec(0);
        authenticator.setSubKey(this.ticket.getSessionKey());
        KerberosTime renewTill = null;
        if (this.getRequestOptions().contains(KrbKdcOption.RENEW)) {
            renewTill = this.ticket.getEncKdcRepPart().getRenewTill();
        }
        KdcReqBody reqBody = this.getReqBody(renewTill);
        CheckSum checksum = CheckSumUtil.seal(reqBody, null, this.ticket.getSessionKey(), KeyUsage.TGS_REQ_AUTH_CKSUM);
        authenticator.setCksum(checksum);
        return authenticator;
    }
}

