/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.apache.kerby.xdr.type;

import io.hops.hadoop.shaded.org.apache.kerby.xdr.XdrDataType;
import io.hops.hadoop.shaded.org.apache.kerby.xdr.type.XdrSimple;
import java.io.IOException;
import java.nio.ByteBuffer;

public class XdrUnsignedInteger
extends XdrSimple<Long> {
    public XdrUnsignedInteger() {
        this((Long)null);
    }

    public XdrUnsignedInteger(String value) {
        this(Long.valueOf(value));
    }

    public XdrUnsignedInteger(Long value) {
        super(XdrDataType.UNSIGNED_INTEGER, value);
    }

    @Override
    protected int encodingBodyLength() {
        return 4;
    }

    @Override
    protected void toBytes() throws IOException {
        Long value = (Long)this.getValue();
        this.validateUnsignedInteger(value);
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        byte[] bytes = new byte[4];
        System.arraycopy(buffer.array(), 4, bytes, 0, 4);
        this.setBytes(bytes);
    }

    private void validateUnsignedInteger(Long value) throws IOException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IOException("Invalid unsigned integer: " + value);
        }
    }

    @Override
    protected void toValue() {
        if (this.getBytes().length != 4) {
            byte[] bytes = ByteBuffer.allocate(4).put(this.getBytes(), 0, 4).array();
            this.setBytes(bytes);
        }
        byte[] longBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(this.getBytes(), 0, longBytes, 4, 4);
        ByteBuffer buffer = ByteBuffer.wrap(longBytes);
        this.setValue(buffer.getLong());
    }
}

