/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.security.authentication;

import io.hops.hadoop.shaded.javax.servlet.ServletRequest;
import io.hops.hadoop.shaded.javax.servlet.ServletResponse;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import io.hops.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import io.hops.hadoop.shaded.org.eclipse.jetty.http.HttpHeader;
import io.hops.hadoop.shaded.org.eclipse.jetty.security.ServerAuthException;
import io.hops.hadoop.shaded.org.eclipse.jetty.security.UserAuthentication;
import io.hops.hadoop.shaded.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import io.hops.hadoop.shaded.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.Authentication;
import io.hops.hadoop.shaded.org.eclipse.jetty.server.UserIdentity;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import io.hops.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;

public class SpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(SpnegoAuthenticator.class);
    private String _authMethod = "SPNEGO";

    public SpnegoAuthenticator() {
    }

    public SpnegoAuthenticator(String authMethod) {
        this._authMethod = authMethod;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    @Override
    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        String spnegoToken;
        UserIdentity user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String header = req.getHeader(HttpHeader.AUTHORIZATION.asString());
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        if (header == null) {
            try {
                if (DeferredAuthentication.isDeferred(res)) {
                    return Authentication.UNAUTHENTICATED;
                }
                LOG.debug("SpengoAuthenticator: sending challenge", new Object[0]);
                res.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), HttpHeader.NEGOTIATE.asString());
                res.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
            catch (IOException ioe) {
                throw new ServerAuthException(ioe);
            }
        }
        if (header != null && header.startsWith(HttpHeader.NEGOTIATE.asString()) && (user = this.login(null, spnegoToken = header.substring(10), request)) != null) {
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        return Authentication.UNAUTHENTICATED;
    }

    @Override
    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

