/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hadoop.shaded.org.eclipse.jetty.webapp;

import io.hops.hadoop.shaded.org.eclipse.jetty.util.resource.Resource;
import io.hops.hadoop.shaded.org.eclipse.jetty.webapp.FragmentDescriptor;
import io.hops.hadoop.shaded.org.eclipse.jetty.webapp.MetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public interface Ordering {
    public List<Resource> order(List<Resource> var1);

    public boolean isAbsolute();

    public boolean hasOther();

    public static class RelativeOrdering
    implements Ordering {
        protected MetaData _metaData;
        protected LinkedList<Resource> _beforeOthers = new LinkedList();
        protected LinkedList<Resource> _afterOthers = new LinkedList();
        protected LinkedList<Resource> _noOthers = new LinkedList();

        public RelativeOrdering(MetaData metaData) {
            this._metaData = metaData;
        }

        @Override
        public List<Resource> order(List<Resource> jars) {
            this._beforeOthers.clear();
            this._afterOthers.clear();
            this._noOthers.clear();
            for (Resource jar : jars) {
                FragmentDescriptor descriptor = this._metaData.getFragment(jar);
                if (descriptor != null) {
                    switch (descriptor.getOtherType()) {
                        case None: {
                            this.addNoOthers(jar);
                            break;
                        }
                        case Before: {
                            this.addBeforeOthers(jar);
                            break;
                        }
                        case After: {
                            this.addAfterOthers(jar);
                        }
                    }
                    continue;
                }
                this.addNoOthers(jar);
            }
            ArrayList<Resource> orderedList = new ArrayList<Resource>();
            int maxIterations = 2;
            boolean done = false;
            do {
                boolean changesBefore = this.orderList(this._beforeOthers);
                boolean changesAfter = this.orderList(this._afterOthers);
                boolean changesNone = this.orderList(this._noOthers);
                boolean bl = done = !changesBefore && !changesAfter && !changesNone;
            } while (!done && --maxIterations > 0);
            if (!done) {
                throw new IllegalStateException("Circular references for fragments");
            }
            for (Resource r : this._beforeOthers) {
                orderedList.add(r);
            }
            for (Resource r : this._noOthers) {
                orderedList.add(r);
            }
            for (Resource r : this._afterOthers) {
                orderedList.add(r);
            }
            return orderedList;
        }

        @Override
        public boolean isAbsolute() {
            return false;
        }

        @Override
        public boolean hasOther() {
            return !this._beforeOthers.isEmpty() || !this._afterOthers.isEmpty();
        }

        public void addBeforeOthers(Resource r) {
            this._beforeOthers.addLast(r);
        }

        public void addAfterOthers(Resource r) {
            this._afterOthers.addLast(r);
        }

        public void addNoOthers(Resource r) {
            this._noOthers.addLast(r);
        }

        protected boolean orderList(LinkedList<Resource> list) {
            boolean changes = false;
            ArrayList<Resource> iterable = new ArrayList<Resource>(list);
            for (Resource r : iterable) {
                List<String> afters;
                FragmentDescriptor f = this._metaData.getFragment(r);
                if (f == null) continue;
                List<String> befores = f.getBefores();
                if (befores != null && !befores.isEmpty()) {
                    for (String b : befores) {
                        if (this.isBefore(list, f.getName(), b)) continue;
                        int idx1 = this.getIndexOf(list, f.getName());
                        int idx2 = this.getIndexOf(list, b);
                        if (idx2 < 0) {
                            changes = true;
                            Resource bResource = this._metaData.getJarForFragment(b);
                            if (bResource == null || !this._noOthers.remove(bResource)) continue;
                            this.insert(list, idx1 + 1, b);
                            continue;
                        }
                        list.remove(idx1);
                        this.insert(list, idx2, f.getName());
                        changes = true;
                    }
                }
                if ((afters = f.getAfters()) == null || afters.isEmpty()) continue;
                for (String a : afters) {
                    if (this.isAfter(list, f.getName(), a)) continue;
                    int idx1 = this.getIndexOf(list, f.getName());
                    int idx2 = this.getIndexOf(list, a);
                    if (idx2 < 0) {
                        changes = true;
                        Resource aResource = this._metaData.getJarForFragment(a);
                        if (aResource == null || !this._noOthers.remove(aResource)) continue;
                        this.insert(list, idx1, aResource);
                        continue;
                    }
                    list.remove(idx2);
                    this.insert(list, idx1, a);
                    changes = true;
                }
            }
            return changes;
        }

        protected boolean isBefore(List<Resource> list, String fragNameA, String fragNameB) {
            int idxa = this.getIndexOf(list, fragNameA);
            int idxb = this.getIndexOf(list, fragNameB);
            if (idxb >= 0 && idxb < idxa) {
                return false;
            }
            if (idxb < 0) {
                if (list == this._beforeOthers) {
                    return true;
                }
                if (list == this._afterOthers) {
                    if (this._beforeOthers.contains(fragNameB)) {
                        throw new IllegalStateException("Incorrect relationship: " + fragNameA + " before " + fragNameB);
                    }
                    return false;
                }
            }
            return true;
        }

        protected boolean isAfter(List<Resource> list, String fragNameA, String fragNameB) {
            int idxa = this.getIndexOf(list, fragNameA);
            int idxb = this.getIndexOf(list, fragNameB);
            if (idxb >= 0 && idxa < idxb) {
                return false;
            }
            if (idxb < 0) {
                if (list == this._afterOthers) {
                    return true;
                }
                if (list == this._beforeOthers) {
                    if (this._afterOthers.contains(fragNameB)) {
                        throw new IllegalStateException("Incorrect relationship: " + fragNameB + " after " + fragNameA);
                    }
                    return false;
                }
            }
            return true;
        }

        protected void insert(List<Resource> list, int index, String fragName) {
            Resource jar = this._metaData.getJarForFragment(fragName);
            if (jar == null) {
                throw new IllegalStateException("No jar for insertion");
            }
            this.insert(list, index, jar);
        }

        protected void insert(List<Resource> list, int index, Resource resource) {
            if (list == null) {
                throw new IllegalStateException("List is null for insertion");
            }
            if (index > list.size()) {
                list.add(resource);
            } else {
                list.add(index, resource);
            }
        }

        protected void remove(List<Resource> resources, Resource r) {
            if (resources == null) {
                return;
            }
            resources.remove(r);
        }

        protected int getIndexOf(List<Resource> resources, String fragmentName) {
            FragmentDescriptor fd = this._metaData.getFragment(fragmentName);
            if (fd == null) {
                return -1;
            }
            Resource r = this._metaData.getJarForFragment(fragmentName);
            if (r == null) {
                return -1;
            }
            return resources.indexOf(r);
        }
    }

    public static class AbsoluteOrdering
    implements Ordering {
        public static final String OTHER = "@@-OTHER-@@";
        protected List<String> _order = new ArrayList<String>();
        protected boolean _hasOther = false;
        protected MetaData _metaData;

        public AbsoluteOrdering(MetaData metaData) {
            this._metaData = metaData;
        }

        @Override
        public List<Resource> order(List<Resource> jars) {
            ArrayList<Resource> orderedList = new ArrayList<Resource>();
            ArrayList<Resource> tmp = new ArrayList<Resource>(jars);
            HashMap<String, FragmentDescriptor> others = new HashMap<String, FragmentDescriptor>(this._metaData.getNamedFragments());
            int index = -1;
            for (String item : this._order) {
                if (!item.equals(OTHER)) {
                    FragmentDescriptor f = (FragmentDescriptor)others.remove(item);
                    if (f == null) continue;
                    Resource jar = this._metaData.getJarForFragment(item);
                    orderedList.add(jar);
                    tmp.remove(jar);
                    continue;
                }
                index = orderedList.size();
            }
            if (this._hasOther) {
                orderedList.addAll(index < 0 ? 0 : index, tmp);
            }
            return orderedList;
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        public void add(String name) {
            this._order.add(name);
        }

        public void addOthers() {
            if (this._hasOther) {
                throw new IllegalStateException("Duplicate <other> element in absolute ordering");
            }
            this._hasOther = true;
            this._order.add(OTHER);
        }

        @Override
        public boolean hasOther() {
            return this._hasOther;
        }
    }
}

