/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawDecoderLegacy;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawEncoderLegacy;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCodecRawCoderMapping {
    private static Configuration conf;
    private static final int numDataUnit = 6;
    private static final int numParityUnit = 3;

    @Before
    public void setup() {
        conf = new Configuration();
    }

    @Test
    public void testRSDefaultRawCoder() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-default", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof RSRawEncoder));
        RawErasureDecoder decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs-default", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(decoder instanceof RSRawDecoder));
        encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof RSRawEncoderLegacy));
        decoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(decoder instanceof RSRawDecoderLegacy));
    }

    @Test
    public void testDedicatedRawCoderKey() {
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        String dummyFactName = "DummyNoneExistingFactory";
        conf.set("io.erasurecode.codec.rs-legacy.rawcoder", dummyFactName);
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-default", (ErasureCoderOptions)coderOptions);
        Assert.assertTrue((boolean)(encoder instanceof RSRawEncoder));
        try {
            CodecUtil.createRawEncoder((Configuration)conf, (String)"rs-legacy", (ErasureCoderOptions)coderOptions);
            Assert.fail();
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains("Failed to create raw coder", e);
        }
    }
}

