/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;
import org.apache.hadoop.io.erasurecode.coder.TestErasureCoderBase;

public abstract class TestHHErasureCoderBase
extends TestErasureCoderBase {
    protected int subPacketSize = 2;

    @Override
    protected void performCodingStep(ErasureCodingStep codingStep) {
        ECBlock[] inputBlocks = codingStep.getInputBlocks();
        ECBlock[] outputBlocks = codingStep.getOutputBlocks();
        ECChunk[] inputChunks = new ECChunk[inputBlocks.length * this.subPacketSize];
        ECChunk[] outputChunks = new ECChunk[outputBlocks.length * this.subPacketSize];
        for (int i = 0; i < this.numChunksInBlock; i += this.subPacketSize) {
            for (int k = 0; k < this.subPacketSize; ++k) {
                int j;
                for (j = 0; j < inputBlocks.length; ++j) {
                    inputChunks[k * inputBlocks.length + j] = ((TestErasureCoderBase.TestBlock)inputBlocks[j]).chunks[i + k];
                }
                for (j = 0; j < outputBlocks.length; ++j) {
                    outputChunks[k * outputBlocks.length + j] = this.allocateOutputChunk();
                    ((TestErasureCoderBase.TestBlock)outputBlocks[j]).chunks[i + k] = outputChunks[k * outputBlocks.length + j];
                }
            }
            codingStep.performCoding(inputChunks, outputChunks);
        }
        codingStep.finish();
    }
}

