/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.hops.security.ServiceJWTManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class AbstractSecurityActions
extends CompositeService {
    public static final Pattern JWT_PATTERN = Pattern.compile("^Bearer\\s(.+)");
    protected static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    public static final String BEARER_AUTH_HEADER_CONTENT = "Bearer %s";
    private static final Set<Integer> ACCEPTABLE_HTTP_RESPONSES = new HashSet<Integer>(2);
    protected final ServiceJWTManager serviceJWTManager = this.createJWTManager();
    protected CloseableHttpClient httpClient;
    protected HttpHost remoteHost;
    protected Gson parser;
    private PoolingHttpClientConnectionManager httpConnectionManager;

    public AbstractSecurityActions(String name) {
        super(name);
        this.addIfService(this.serviceJWTManager);
        this.parser = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected ServiceJWTManager createJWTManager() {
        return new ServiceJWTManager("JWT Manager");
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.remoteHost = HttpHost.create((String)conf.get("hops.hopsworks.host", "https://127.0.0.1"));
        super.serviceInit(conf);
    }

    protected PoolingHttpClientConnectionManager createHTTPConnectionManager() throws GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(50);
        return connectionManager;
    }

    @Override
    protected void serviceStart() throws Exception {
        this.httpConnectionManager = this.createHTTPConnectionManager();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).build();
        if (this.serviceJWTManager != null) {
            this.serviceJWTManager.setHTTPClient(this.httpClient);
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        super.serviceStop();
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
    }

    protected void checkHTTPResponseCode(HttpResponse response, String extraMessage) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (!ACCEPTABLE_HTTP_RESPONSES.contains(code)) {
            throw new IOException("HTTP error, response code " + code + " Reason: " + response.getStatusLine().getReasonPhrase() + " Message: " + extraMessage);
        }
    }

    protected void addJWTAuthHeader(HttpRequest request, String token) {
        String authHeaderContent = String.format(BEARER_AUTH_HEADER_CONTENT, token);
        request.addHeader("Authorization", authHeaderContent);
    }

    protected void addJSONContentType(HttpRequest request) {
        this.addContentTypeHeader(request, ContentType.APPLICATION_JSON.toString());
    }

    protected void addTextPlainContentType(HttpRequest request) {
        this.addContentTypeHeader(request, ContentType.TEXT_PLAIN.toString());
    }

    private void addContentTypeHeader(HttpRequest request, String contentType) {
        request.addHeader("Content-Type", contentType);
    }

    static {
        ACCEPTABLE_HTTP_RESPONSES.add(200);
        ACCEPTABLE_HTTP_RESPONSES.add(204);
    }
}

