/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ContentSummary
implements Writable {
    private long length;
    private long fileCount;
    private long directoryCount;
    private long quota;
    private long spaceConsumed;
    private long spaceQuota;
    private long[] typeConsumed;
    private long[] typeQuota;
    private static final String SUMMARY_FORMAT = "%12s %12s %18s ";
    private static final String QUOTA_SUMMARY_FORMAT = "%12s %15s ";
    private static final String SPACE_QUOTA_SUMMARY_FORMAT = "%15s %15s ";
    private static final String STORAGE_TYPE_SUMMARY_FORMAT = "%13s %17s ";
    private static final String[] HEADER_FIELDS = new String[]{"DIR_COUNT", "FILE_COUNT", "CONTENT_SIZE"};
    private static final String[] QUOTA_HEADER_FIELDS = new String[]{"QUOTA", "REM_QUOTA", "SPACE_QUOTA", "REM_SPACE_QUOTA"};
    private static final String HEADER = String.format("%12s %12s %18s ", HEADER_FIELDS);
    private static final String QUOTA_HEADER = String.format("%12s %15s %15s %15s ", QUOTA_HEADER_FIELDS) + HEADER;
    private static final String QUOTA_NONE = "none";
    private static final String QUOTA_INF = "inf";

    @Deprecated
    public ContentSummary() {
    }

    @Deprecated
    public ContentSummary(long length, long fileCount, long directoryCount) {
        this(length, fileCount, directoryCount, -1L, length, -1L);
    }

    @Deprecated
    public ContentSummary(long length, long fileCount, long directoryCount, long quota, long spaceConsumed, long spaceQuota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = quota;
        this.spaceConsumed = spaceConsumed;
        this.spaceQuota = spaceQuota;
    }

    private ContentSummary(long length, long fileCount, long directoryCount, long quota, long spaceConsumed, long spaceQuota, long[] typeConsumed, long[] typeQuota) {
        this.length = length;
        this.fileCount = fileCount;
        this.directoryCount = directoryCount;
        this.quota = quota;
        this.spaceConsumed = spaceConsumed;
        this.spaceQuota = spaceQuota;
        this.typeConsumed = typeConsumed;
        this.typeQuota = typeQuota;
    }

    public long getLength() {
        return this.length;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getQuota() {
        return this.quota;
    }

    public long getSpaceConsumed() {
        return this.spaceConsumed;
    }

    public long getSpaceQuota() {
        return this.spaceQuota;
    }

    public long getTypeQuota(StorageType type) {
        return this.typeQuota != null ? this.typeQuota[type.ordinal()] : -1L;
    }

    public long getTypeConsumed(StorageType type) {
        return this.typeConsumed != null ? this.typeConsumed[type.ordinal()] : 0L;
    }

    public boolean isTypeQuotaSet() {
        if (this.typeQuota == null) {
            return false;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (this.typeQuota[t.ordinal()] <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeConsumedAvailable() {
        if (this.typeConsumed == null) {
            return false;
        }
        for (StorageType t : StorageType.getTypesSupportingQuota()) {
            if (this.typeConsumed[t.ordinal()] <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    @InterfaceAudience.Private
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.length);
        out.writeLong(this.fileCount);
        out.writeLong(this.directoryCount);
        out.writeLong(this.quota);
        out.writeLong(this.spaceConsumed);
        out.writeLong(this.spaceQuota);
    }

    @Override
    @InterfaceAudience.Private
    public void readFields(DataInput in) throws IOException {
        this.length = in.readLong();
        this.fileCount = in.readLong();
        this.directoryCount = in.readLong();
        this.quota = in.readLong();
        this.spaceConsumed = in.readLong();
        this.spaceQuota = in.readLong();
    }

    public static String getHeader(boolean qOption) {
        return qOption ? QUOTA_HEADER : HEADER;
    }

    public static String getStorageTypeHeader(List<StorageType> storageTypes) {
        StringBuffer header = new StringBuffer();
        for (StorageType st : storageTypes) {
            String storageName = st.toString();
            header.append(String.format(STORAGE_TYPE_SUMMARY_FORMAT, storageName + "_QUOTA", "REM_" + storageName + "_QUOTA"));
        }
        return header.toString();
    }

    public static String[] getHeaderFields() {
        return HEADER_FIELDS;
    }

    public static String[] getQuotaHeaderFields() {
        return QUOTA_HEADER_FIELDS;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean qOption) {
        return this.toString(qOption, false);
    }

    public String toString(boolean qOption, boolean hOption) {
        return this.toString(qOption, hOption, false, null);
    }

    public String toString(boolean qOption, boolean hOption, boolean tOption, List<StorageType> types) {
        String prefix = "";
        if (tOption) {
            StringBuffer content = new StringBuffer();
            for (StorageType st : types) {
                long typeQuota = this.getTypeQuota(st);
                long typeConsumed = this.getTypeConsumed(st);
                String quotaStr = QUOTA_NONE;
                String quotaRem = QUOTA_INF;
                if (typeQuota > 0L) {
                    quotaStr = this.formatSize(typeQuota, hOption);
                    quotaRem = this.formatSize(typeQuota - typeConsumed, hOption);
                }
                content.append(String.format(STORAGE_TYPE_SUMMARY_FORMAT, quotaStr, quotaRem));
            }
            return content.toString();
        }
        if (qOption) {
            String quotaStr = QUOTA_NONE;
            String quotaRem = QUOTA_INF;
            String spaceQuotaStr = QUOTA_NONE;
            String spaceQuotaRem = QUOTA_INF;
            if (this.quota > 0L) {
                quotaStr = this.formatSize(this.quota, hOption);
                quotaRem = this.formatSize(this.quota - (this.directoryCount + this.fileCount), hOption);
            }
            if (this.spaceQuota > 0L) {
                spaceQuotaStr = this.formatSize(this.spaceQuota, hOption);
                spaceQuotaRem = this.formatSize(this.spaceQuota - this.spaceConsumed, hOption);
            }
            prefix = String.format("%12s %15s %15s %15s ", quotaStr, quotaRem, spaceQuotaStr, spaceQuotaRem);
        }
        return prefix + String.format(SUMMARY_FORMAT, this.formatSize(this.directoryCount, hOption), this.formatSize(this.fileCount, hOption), this.formatSize(this.length, hOption));
    }

    private String formatSize(long size, boolean humanReadable) {
        return humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    public static class Builder {
        private long length;
        private long fileCount;
        private long directoryCount;
        private long quota = -1L;
        private long spaceConsumed;
        private long spaceQuota = -1L;
        private long[] typeConsumed = new long[StorageType.values().length];
        private long[] typeQuota = new long[StorageType.values().length];

        public Builder() {
            for (int i = 0; i < this.typeQuota.length; ++i) {
                this.typeQuota[i] = -1L;
            }
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder fileCount(long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        public Builder directoryCount(long directoryCount) {
            this.directoryCount = directoryCount;
            return this;
        }

        public Builder quota(long quota) {
            this.quota = quota;
            return this;
        }

        public Builder spaceConsumed(long spaceConsumed) {
            this.spaceConsumed = spaceConsumed;
            return this;
        }

        public Builder spaceQuota(long spaceQuota) {
            this.spaceQuota = spaceQuota;
            return this;
        }

        public Builder typeConsumed(long[] typeConsumed) {
            for (int i = 0; i < typeConsumed.length; ++i) {
                this.typeConsumed[i] = typeConsumed[i];
            }
            return this;
        }

        public Builder typeQuota(StorageType type, long quota) {
            this.typeQuota[type.ordinal()] = quota;
            return this;
        }

        public Builder typeConsumed(StorageType type, long consumed) {
            this.typeConsumed[type.ordinal()] = consumed;
            return this;
        }

        public Builder typeQuota(long[] typeQuota) {
            for (int i = 0; i < typeQuota.length; ++i) {
                this.typeQuota[i] = typeQuota[i];
            }
            return this;
        }

        public ContentSummary build() {
            return new ContentSummary(this.length, this.fileCount, this.directoryCount, this.quota, this.spaceConsumed, this.spaceQuota, this.typeConsumed, this.typeQuota);
        }
    }
}

