/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.EntityManager;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.util.LightWeightCacheDistributed;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class RetryCacheDistributed
extends RetryCache {
    public RetryCacheDistributed(String cacheName, double percentage, long expirationTime) {
        super(cacheName, percentage, expirationTime);
        int capacity = LightWeightGSet.computeCapacity(percentage, cacheName);
        capacity = capacity > 16 ? capacity : 16;
        this.set = new LightWeightCacheDistributed(capacity, capacity, expirationTime, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetryCache.CacheEntry waitForCompletion(RetryCache.CacheEntry newEntry) {
        RetryCache.CacheEntry mapEntry = null;
        this.lock.lock();
        try {
            mapEntry = (RetryCache.CacheEntry)this.set.get(newEntry);
            if (mapEntry == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Adding Rpc request clientId " + newEntry.clientIdMsb + newEntry.clientIdLsb + " callId " + newEntry.callId + " to retryCache"));
                }
                this.set.put(newEntry);
                this.retryCacheMetrics.incrCacheUpdated();
                RetryCache.CacheEntry cacheEntry = newEntry;
                return cacheEntry;
            }
            this.retryCacheMetrics.incrCacheHit();
        }
        finally {
            this.lock.unlock();
        }
        Preconditions.checkNotNull((Object)mapEntry, (Object)"Entry from the cache should not be null");
        RetryCache.CacheEntry cacheEntry = mapEntry;
        synchronized (cacheEntry) {
            while (mapEntry.state == 0) {
                try {
                    mapEntry.wait();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            if (mapEntry.state != 1) {
                mapEntry.state = 0;
            }
        }
        return mapEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCacheEntry(byte[] clientId, int callId) {
        RetryCache.CacheEntry newEntry = new RetryCache.CacheEntry(clientId, callId, System.currentTimeMillis() + this.expirationTime, true);
        this.lock.lock();
        try {
            this.set.put(newEntry);
        }
        finally {
            this.lock.unlock();
        }
        this.retryCacheMetrics.incrCacheUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheEntryWithPayload(byte[] clientId, int callId, byte[] payload) {
        CacheEntryWithPayload newEntry = new CacheEntryWithPayload(clientId, callId, payload, System.currentTimeMillis() + this.expirationTime, true);
        this.lock.lock();
        try {
            this.set.put(newEntry);
        }
        finally {
            this.lock.unlock();
        }
        this.retryCacheMetrics.incrCacheUpdated();
    }

    private static RetryCache.CacheEntry newEntry(long expirationTime) {
        return new RetryCache.CacheEntry(Server.getClientId(), Server.getCallId(), System.currentTimeMillis() + expirationTime);
    }

    private static CacheEntryWithPayload newEntry(byte[] payload, long expirationTime) {
        return new CacheEntryWithPayload(Server.getClientId(), Server.getCallId(), payload, System.currentTimeMillis() + expirationTime);
    }

    public static RetryCache.CacheEntry waitForCompletion(RetryCacheDistributed cache) {
        if (RetryCacheDistributed.skipRetryCache()) {
            return null;
        }
        return cache != null ? cache.waitForCompletion(RetryCacheDistributed.newEntry(cache.expirationTime)) : null;
    }

    public static CacheEntryWithPayload waitForCompletion(RetryCacheDistributed cache, byte[] payload) {
        if (RetryCacheDistributed.skipRetryCache()) {
            return null;
        }
        return (CacheEntryWithPayload)(cache != null ? cache.waitForCompletion(RetryCacheDistributed.newEntry(payload, cache.expirationTime)) : null);
    }

    public static void setState(RetryCache.CacheEntry e, boolean success) {
        if (e == null) {
            return;
        }
        e.completed(success);
        try {
            EntityManager.update((Object)new RetryCacheEntry(e.getClientId(), e.getCallId(), null, e.getExpirationTime(), e.getState()));
        }
        catch (StorageException | TransactionContextException ex) {
            LOG.error((Object)"did not persist cach to the database", ex);
        }
    }

    public static void setState(CacheEntryWithPayload e, boolean success, byte[] payload) throws TransactionContextException, StorageException {
        if (e == null) {
            return;
        }
        CacheEntryWithPayload.access$002(e, payload);
        e.completed(success);
        EntityManager.update((Object)new RetryCacheEntry(e.getClientId(), e.getCallId(), e.getPayload(), e.getExpirationTime(), e.getState()));
    }

    public static void clear(RetryCacheDistributed cache) {
        if (cache != null) {
            cache.set.clear();
            cache.incrCacheClearedCounter();
        }
    }

    public LinkedBlockingQueue<RetryCache.CacheEntry> getToRemove() {
        return ((LightWeightCacheDistributed)this.set).getToRemove();
    }

    public static class CacheEntryWithPayload
    extends RetryCache.CacheEntry {
        private byte[] payload;

        CacheEntryWithPayload(byte[] clientId, int callId, byte[] payload, long expirationTime) {
            super(clientId, callId, expirationTime);
            this.payload = payload;
        }

        public CacheEntryWithPayload(byte[] clientId, int callId, byte[] payload, long expirationTime, byte state) {
            super(clientId, callId, expirationTime);
            this.payload = payload;
            this.state = state;
        }

        CacheEntryWithPayload(byte[] clientId, int callId, byte[] payload, long expirationTime, boolean success) {
            super(clientId, callId, expirationTime, success);
            this.payload = payload;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        public byte[] getPayload() {
            return this.payload;
        }

        static /* synthetic */ byte[] access$002(CacheEntryWithPayload x0, byte[] x1) {
            x0.payload = x1;
            return x1;
        }
    }
}

