/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.lang.reflect.Constructor;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.TestCoderBase;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestRawCoderBase
extends TestCoderBase {
    protected Class<? extends RawErasureEncoder> encoderClass;
    protected Class<? extends RawErasureDecoder> decoderClass;
    protected RawErasureEncoder encoder;
    protected RawErasureDecoder decoder;

    protected void testCodingDoMixAndTwice() {
        this.testCodingDoMixed();
        this.testCodingDoMixed();
    }

    protected void testCodingDoMixed() {
        this.testCoding(true);
        this.testCoding(false);
    }

    protected void testCoding(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        this.performTestCoding(this.baseChunkSize, true, false, false, false);
        this.performTestCoding(this.baseChunkSize - 17, false, false, false, true);
        this.performTestCoding(this.baseChunkSize + 16, true, false, false, false);
    }

    protected void testCodingWithBadInput(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        try {
            this.performTestCoding(this.baseChunkSize, false, true, false, true);
            Assert.fail((String)"Encoding test with bad input should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void testCodingWithBadOutput(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        try {
            this.performTestCoding(this.baseChunkSize, false, false, true, true);
            Assert.fail((String)"Decoding test with bad output should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCodingWithErasingTooMany() {
        try {
            this.testCoding(true);
            Assert.fail((String)"Decoding test erasing too many should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.testCoding(false);
            Assert.fail((String)"Decoding test erasing too many should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void performTestCoding(int chunkSize, boolean usingSlicedBuffer, boolean useBadInput, boolean useBadOutput, boolean allowChangeInputs) {
        this.setChunkSize(chunkSize);
        this.prepareBufferAllocator(usingSlicedBuffer);
        this.setAllowChangeInputs(allowChangeInputs);
        this.dumpSetting();
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        if (useBadInput) {
            this.corruptSomeChunk(dataChunks);
        }
        this.dumpChunks("Testing data chunks", dataChunks);
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        this.markChunks(dataChunks);
        this.encoder.encode(dataChunks, parityChunks);
        this.dumpChunks("Encoded parity chunks", parityChunks);
        if (!allowChangeInputs) {
            this.restoreChunksFromMark(dataChunks);
            this.compareAndVerify(clonedDataChunks, dataChunks);
        }
        ECChunk[] backupChunks = this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        if (useBadOutput) {
            this.corruptSomeChunk(recoveredChunks);
        }
        ECChunk[] clonedInputChunks = null;
        if (!allowChangeInputs) {
            this.markChunks(inputChunks);
            clonedInputChunks = this.cloneChunksWithData(inputChunks);
        }
        this.dumpChunks("Decoding input chunks", inputChunks);
        this.decoder.decode(inputChunks, this.getErasedIndexesForDecoding(), recoveredChunks);
        this.dumpChunks("Decoded/recovered chunks", recoveredChunks);
        if (!allowChangeInputs) {
            this.restoreChunksFromMark(inputChunks);
            this.compareAndVerify(clonedInputChunks, inputChunks);
        }
        this.compareAndVerify(backupChunks, recoveredChunks);
    }

    protected void setAllowChangeInputs(boolean allowChangeInputs) {
        this.allowChangeInputs = allowChangeInputs;
    }

    protected void setAllowDump(boolean allowDump) {
        this.allowDump = allowDump;
    }

    protected void prepareCoders(boolean recreate) {
        if (this.encoder == null || recreate) {
            this.encoder = this.createEncoder();
        }
        if (this.decoder == null || recreate) {
            this.decoder = this.createDecoder();
        }
    }

    protected void ensureOnlyLeastRequiredChunks(ECChunk[] inputChunks) {
        int leastRequiredNum = this.numDataUnits;
        int erasedNum = this.erasedDataIndexes.length + this.erasedParityIndexes.length;
        int goodNum = inputChunks.length - erasedNum;
        int redundantNum = goodNum - leastRequiredNum;
        for (int i = 0; i < inputChunks.length && redundantNum > 0; ++i) {
            if (inputChunks[i] == null) continue;
            inputChunks[i] = null;
            --redundantNum;
        }
    }

    protected RawErasureEncoder createEncoder() {
        ErasureCoderOptions coderConf = new ErasureCoderOptions(this.numDataUnits, this.numParityUnits, this.allowChangeInputs, this.allowDump);
        try {
            Constructor<? extends RawErasureEncoder> constructor = this.encoderClass.getConstructor(ErasureCoderOptions.class);
            return constructor.newInstance(coderConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create encoder", e);
        }
    }

    protected RawErasureDecoder createDecoder() {
        ErasureCoderOptions coderConf = new ErasureCoderOptions(this.numDataUnits, this.numParityUnits, this.allowChangeInputs, this.allowDump);
        try {
            Constructor<? extends RawErasureDecoder> constructor = this.decoderClass.getConstructor(ErasureCoderOptions.class);
            return constructor.newInstance(coderConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create decoder", e);
        }
    }

    protected void testInputPosition(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(true);
        this.prepareBufferAllocator(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        this.encoder.encode(dataChunks, parityChunks);
        this.verifyBufferPositionAtEnd(dataChunks);
        this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        this.decoder.decode(inputChunks, this.getErasedIndexesForDecoding(), recoveredChunks);
        this.verifyBufferPositionAtEnd(inputChunks);
    }

    private void verifyBufferPositionAtEnd(ECChunk[] inputChunks) {
        for (ECChunk chunk : inputChunks) {
            if (chunk == null) continue;
            Assert.assertEquals((long)0L, (long)chunk.getBuffer().remaining());
        }
    }
}

