/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.ssl.KeyManagersReloaderThreadPool;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.ReloadingX509KeyManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestReloadingX509KeyManager {
    private static final String BASE_DIR = GenericTestUtils.getTempPath(TestReloadingX509KeyManager.class.getSimpleName());
    private static final File baseDirFile = new File(BASE_DIR);
    private final Log LOG = LogFactory.getLog(TestReloadingX509KeyManager.class);
    private final String KEY_PAIR_ALGORITHM = "RSA";
    private final String CERTIFICATE_ALGORITHM = "SHA1withRSA";
    private final String KEYSTORE_PASSWORD = "password";
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @BeforeClass
    public static void setUp() throws IOException {
        FileUtils.deleteDirectory((File)baseDirFile);
        baseDirFile.mkdirs();
    }

    @Before
    public void beforeTest() {
        KeyManagersReloaderThreadPool.getInstance((boolean)true).clearListOfTasks();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)baseDirFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testReload() throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert1 = KeyStoreTestUtil.generateCertificate("CN=cert1", keyPair, 2, "SHA1withRSA");
        String keyStoreLocation = Paths.get(BASE_DIR, "testKeystore.jks").toString();
        KeyStoreTestUtil.createKeyStore(keyStoreLocation, "password", "cert1", keyPair.getPrivate(), cert1);
        ReloadingX509KeyManager keyManager = new ReloadingX509KeyManager("jks", keyStoreLocation, "password", "password", 10L, TimeUnit.MILLISECONDS);
        try {
            keyManager.init();
            TimeUnit reloadTimeUnit = keyManager.getReloadTimeUnit();
            long reloadInterval = keyManager.getReloadInterval();
            X509Certificate[] certChain = keyManager.getCertificateChain("cert1");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert1", (Object)certChain);
            Assert.assertEquals((String)"Certificate chain should be 1", (long)1L, (long)certChain.length);
            Assert.assertEquals((String)"DN for cert1 should be CN=cert1", (Object)cert1.getSubjectDN().getName(), (Object)certChain[0].getSubjectDN().getName());
            reloadTimeUnit.sleep(reloadInterval);
            TimeUnit.SECONDS.sleep(1L);
            X509Certificate cert2 = KeyStoreTestUtil.generateCertificate("CN=cert2", keyPair, 2, "SHA1withRSA");
            KeyStoreTestUtil.createKeyStore(keyStoreLocation, "password", "cert2", keyPair.getPrivate(), cert2);
            reloadTimeUnit.sleep(reloadInterval * 2L);
            certChain = keyManager.getCertificateChain("cert1");
            Assert.assertNull((String)"Certificate chain for alias cert1 should be null", (Object)certChain);
            certChain = keyManager.getCertificateChain("cert2");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert2", (Object)certChain);
            Assert.assertEquals((String)"Certificate chain should be 1", (long)1L, (long)certChain.length);
            Assert.assertEquals((String)"DN for cert2 should be CN=cert2", (Object)cert2.getSubjectDN().getName(), (Object)certChain[0].getSubjectDN().getName());
        }
        finally {
            keyManager.stop();
        }
    }

    @Test
    public void testLoadMissingKeyStore() throws Exception {
        String keyStoreLocation = Paths.get(BASE_DIR, "testKeystore.jks").toString();
        this.rule.expect(IOException.class);
        ReloadingX509KeyManager keyManager = new ReloadingX509KeyManager("jks", keyStoreLocation, "", "", 10L, TimeUnit.MILLISECONDS);
        try {
            keyManager.init();
        }
        finally {
            keyManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadCorruptedKeyStore() throws Exception {
        String keyStoreLocation = Paths.get(BASE_DIR, "corrupterTestKeystore.jks").toString();
        FileOutputStream outputStream = new FileOutputStream(keyStoreLocation);
        outputStream.write("something".getBytes());
        outputStream.close();
        this.rule.expect(IOException.class);
        this.rule.expectMessage("Invalid keystore format");
        ReloadingX509KeyManager keyManager = new ReloadingX509KeyManager("jks", keyStoreLocation, "", "", 10L, TimeUnit.MILLISECONDS);
        try {
            keyManager.init();
        }
        finally {
            keyManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testReloadMissingKeyStore() throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate("CN=cert", keyPair, 2, "SHA1withRSA");
        String keyStoreLocation = Paths.get(BASE_DIR, "testKeystore.jks").toString();
        KeyStoreTestUtil.createKeyStore(keyStoreLocation, "password", "cert", keyPair.getPrivate(), cert);
        ReloadingX509KeyManager keyManager = new ReloadingX509KeyManager("jks", keyStoreLocation, "password", "password", 10L, TimeUnit.MILLISECONDS);
        try {
            keyManager.init();
            X509Certificate[] certChain = keyManager.getCertificateChain("cert");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert", (Object)certChain);
            FileUtils.forceDelete((File)new File(keyStoreLocation));
            keyManager.getReloadTimeUnit().sleep(keyManager.getReloadInterval());
            TimeUnit.SECONDS.sleep(1L);
            AtomicBoolean fileExists = keyManager.getFileExists();
            Assert.assertFalse((String)"Key manager should detect file does not exist", (boolean)fileExists.get());
            certChain = keyManager.getCertificateChain("cert");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert", (Object)certChain);
        }
        finally {
            keyManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testReloadCorruptedKeyStore() throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert = KeyStoreTestUtil.generateCertificate("CN=cert", keyPair, 2, "SHA1withRSA");
        String keyStoreLocation = Paths.get(BASE_DIR, "testKeystore.jks").toString();
        KeyStoreTestUtil.createKeyStore(keyStoreLocation, "password", "cert", keyPair.getPrivate(), cert);
        ReloadingX509KeyManager keyManager = new ReloadingX509KeyManager("jks", keyStoreLocation, "password", "password", 10L, TimeUnit.MILLISECONDS);
        try {
            keyManager.init();
            X509Certificate[] certChain = keyManager.getCertificateChain("cert");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert", (Object)certChain);
            keyManager.getReloadTimeUnit().sleep(keyManager.getReloadInterval());
            TimeUnit.SECONDS.sleep(1L);
            FileOutputStream outputStream = new FileOutputStream(keyStoreLocation);
            outputStream.write("something".getBytes());
            outputStream.close();
            keyManager.getReloadTimeUnit().sleep(keyManager.getReloadInterval());
            TimeUnit.SECONDS.sleep(1L);
            certChain = keyManager.getCertificateChain("cert");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert", (Object)certChain);
            Assert.assertEquals((String)"DN for cert should be CN=cert", (Object)cert.getSubjectDN().getName(), (Object)certChain[0].getSubjectDN().getName());
            List reloadTasks = KeyManagersReloaderThreadPool.getInstance((boolean)true).getListOfTasks();
            for (ScheduledFuture task : reloadTasks) {
                Assert.assertTrue((boolean)task.isCancelled());
            }
            Assert.assertEquals((long)4L, (long)keyManager.getNumberOfFailures());
        }
        finally {
            keyManager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadWithPasswordfile() throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        X509Certificate cert1 = KeyStoreTestUtil.generateCertificate("CN=cert1", keyPair, 2, "SHA1withRSA");
        String keyStoreLocation = Paths.get(BASE_DIR, "testKeystore.jks").toString();
        KeyStoreTestUtil.createKeyStore(keyStoreLocation, "password", "cert1", keyPair.getPrivate(), cert1);
        String passwordFileLocation = Paths.get(BASE_DIR, "password_file").toString();
        FileUtils.write((File)new File(passwordFileLocation), (CharSequence)"password");
        ReloadingX509KeyManager keyManager = new ReloadingX509KeyManager("jks", keyStoreLocation, "wrong-password", passwordFileLocation, "wrong-password", 10L, TimeUnit.MILLISECONDS);
        try {
            keyManager.init();
            TimeUnit reloadTimeUnit = keyManager.getReloadTimeUnit();
            long reloadInterval = keyManager.getReloadInterval();
            X509Certificate[] certChain = keyManager.getCertificateChain("cert1");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert1", (Object)certChain);
            Assert.assertEquals((String)"Certificate chain should be 1", (long)1L, (long)certChain.length);
            Assert.assertEquals((String)"DN for cert1 should be CN=cert1", (Object)cert1.getSubjectDN().getName(), (Object)certChain[0].getSubjectDN().getName());
            reloadTimeUnit.sleep(reloadInterval);
            TimeUnit.SECONDS.sleep(1L);
            X509Certificate cert2 = KeyStoreTestUtil.generateCertificate("CN=cert2", keyPair, 2, "SHA1withRSA");
            String newKeystorePassword = "password1";
            KeyStoreTestUtil.createKeyStore(keyStoreLocation, newKeystorePassword, "cert2", keyPair.getPrivate(), cert2);
            FileUtils.write((File)new File(passwordFileLocation), (CharSequence)newKeystorePassword);
            reloadTimeUnit.sleep(reloadInterval * 2L);
            certChain = keyManager.getCertificateChain("cert1");
            Assert.assertNull((String)"Certificate chain for alias cert1 should be null", (Object)certChain);
            certChain = keyManager.getCertificateChain("cert2");
            Assert.assertNotNull((String)"Certificate chain should not be null for alias cert2", (Object)certChain);
            Assert.assertEquals((String)"Certificate chain should be 1", (long)1L, (long)certChain.length);
            Assert.assertEquals((String)"DN for cert2 should be CN=cert2", (Object)cert2.getSubjectDN().getName(), (Object)certChain[0].getSubjectDN().getName());
        }
        finally {
            keyManager.stop();
        }
    }
}

