/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.CertificateLocalization;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.net.hopssslchecks.SSLMaterialAlreadyConfiguredException;
import org.apache.hadoop.security.UserGroupInformation;

public class SuperUserHopsSSLCheck
extends AbstractHopsSSLCheck {
    private static final Log LOG = LogFactory.getLog(SuperUserHopsSSLCheck.class);

    public SuperUserHopsSSLCheck() {
        super(-1);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperUsers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        String username = ugi.getUserName();
        if (proxySuperUsers.contains(username)) {
            try {
                this.isConfigurationNeededForSuperUser(username, configuration);
            }
            catch (SSLMaterialAlreadyConfiguredException ex) {
                return new HopsSSLCryptoMaterial(configuration.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()), configuration.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Found crypto material with the hostname");
            }
            if (certificateLocalization != null) {
                return new HopsSSLCryptoMaterial(certificateLocalization.getSuperKeystoreLocation(), certificateLocalization.getSuperKeystorePass(), certificateLocalization.getSuperKeyPassword(), certificateLocalization.getSuperTruststoreLocation(), certificateLocalization.getSuperTruststorePass());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"*** Called setTlsConfiguration for superuser but CertificateLocalization is NULL");
            }
            return this.readSuperuserMaterialFromFile(configuration);
        }
        return null;
    }
}

