/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.EntityManager;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.RetryCache;
import org.apache.hadoop.ipc.RetryCacheDistributed;
import org.apache.hadoop.util.LightWeightCache;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
public class LightWeightCacheDistributed
extends LightWeightCache<RetryCache.CacheEntry, RetryCache.CacheEntry> {
    private final LinkedBlockingQueue<RetryCache.CacheEntry> toRemove = new LinkedBlockingQueue();

    public LightWeightCacheDistributed(int recommendedLength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod) {
        super(recommendedLength, sizeLimit, creationExpirationPeriod, accessExpirationPeriod, new Timer());
    }

    @VisibleForTesting
    LightWeightCacheDistributed(int recommendedLength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod, Timer timer) {
        super(recommendedLength, sizeLimit, creationExpirationPeriod, accessExpirationPeriod, timer);
    }

    @Override
    protected RetryCache.CacheEntry evict() {
        RetryCache.CacheEntry polled = (RetryCache.CacheEntry)super.evict();
        this.toRemove.add(polled);
        return polled;
    }

    @Override
    public RetryCache.CacheEntry get(RetryCache.CacheEntry key) {
        RetryCache.CacheEntry entry = (RetryCache.CacheEntry)super.get(key);
        try {
            RetryCacheEntry existInDB = (RetryCacheEntry)EntityManager.find((FinderType)RetryCacheEntry.Finder.ByClientIdAndCallId, (Object[])new Object[]{key.getClientId(), key.getCallId()});
            if (existInDB != null && existInDB.getExpirationTime() > this.timer.now()) {
                byte state = existInDB.getState() == 0 ? (byte)2 : (byte)existInDB.getState();
                RetryCacheDistributed.CacheEntryWithPayload exist = new RetryCacheDistributed.CacheEntryWithPayload(existInDB.getClientId(), existInDB.getCallId(), existInDB.getPayload(), existInDB.getExpirationTime(), state);
                if (entry == null) {
                    super.put(exist, this.accessExpirationPeriod);
                    entry = exist;
                }
                existInDB.setExpirationTime(entry.getExpirationTime());
                EntityManager.update((Object)existInDB);
            } else if (entry != null) {
                super.remove(entry);
                entry = null;
            }
        }
        catch (StorageException | TransactionContextException ex) {
            LOG.error((Object)"failed to get or update entry in DB", ex);
            entry = null;
        }
        return entry;
    }

    @Override
    public RetryCache.CacheEntry put(RetryCache.CacheEntry entry) {
        RetryCache.CacheEntry existing = super.put(entry);
        try {
            byte[] payload = null;
            if (entry instanceof RetryCacheDistributed.CacheEntryWithPayload) {
                payload = ((RetryCacheDistributed.CacheEntryWithPayload)entry).getPayload();
            }
            EntityManager.update((Object)new RetryCacheEntry(entry.getClientId(), entry.getCallId(), payload, entry.getExpirationTime(), entry.getState()));
        }
        catch (StorageException | TransactionContextException ex) {
            LOG.error((Object)"failed to put entry ind db", ex);
        }
        return existing;
    }

    @Override
    public RetryCache.CacheEntry remove(RetryCache.CacheEntry key) {
        RetryCache.CacheEntry removed = (RetryCache.CacheEntry)super.remove(key);
        if (removed != null) {
            this.toRemove.add(removed);
        }
        return removed;
    }

    public LinkedBlockingQueue<RetryCache.CacheEntry> getToRemove() {
        return this.toRemove;
    }

    public static interface Entry
    extends LightWeightCache.Entry {
        public void setFromDB();

        public boolean isFromDB();
    }
}

