/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.KDiag;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestKDiag
extends Assert {
    private static final Logger LOG = LoggerFactory.getLogger(TestKDiag.class);
    public static final String KEYLEN = "128";
    public static final String HDFS_SITE_XML = "org/apache/hadoop/security/secure-hdfs-site.xml";
    @Rule
    public TestName methodName = new TestName();
    @Rule
    public Timeout testTimeout = new Timeout(30000);
    private static MiniKdc kdc;
    private static File workDir;
    private static File keytab;
    private static Properties securityProperties;
    private static Configuration conf;

    @BeforeClass
    public static void nameThread() {
        Thread.currentThread().setName("JUnit");
    }

    @BeforeClass
    public static void startMiniKdc() throws Exception {
        workDir = new File(System.getProperty("test.dir", "target"));
        securityProperties = MiniKdc.createConf();
        kdc = new MiniKdc(securityProperties, workDir);
        kdc.start();
        keytab = TestKDiag.createKeytab("foo");
        conf = new Configuration();
        conf.set("hadoop.security.authentication", "KERBEROS");
    }

    @AfterClass
    public static synchronized void stopMiniKdc() {
        if (kdc != null) {
            kdc.stop();
            kdc = null;
        }
    }

    @Before
    public void reset() {
        UserGroupInformation.reset();
    }

    private static File createKeytab(String ... principals) throws Exception {
        File keytab = new File(workDir, "keytab");
        kdc.createPrincipal(keytab, principals);
        return keytab;
    }

    void kdiagFailure(String category, String ... args) throws Exception {
        block2: {
            try {
                int ex = KDiag.exec((Configuration)conf, (String[])args);
                LOG.error("Expected an exception in category {}, return code {}", (Object)category, (Object)ex);
            }
            catch (KDiag.KerberosDiagsFailure e) {
                if (e.getCategory().equals(category)) break block2;
                LOG.error("Expected an exception in category {}, got {}", new Object[]{category, e, e});
                throw e;
            }
        }
    }

    void kdiag(String ... args) throws Exception {
        KDiag.exec((Configuration)conf, (String[])args);
    }

    @Test
    public void testBasicLoginFailure() throws Throwable {
        this.kdiagFailure("LOGIN", "--keylen", KEYLEN);
    }

    @Test
    public void testBasicLoginSkipped() throws Throwable {
        this.kdiagFailure("LOGIN", "--keylen", KEYLEN, "--nologin");
    }

    @Test
    public void testSecure() throws Throwable {
        this.kdiagFailure("CONFIG", "--keylen", KEYLEN, "--secure");
    }

    @Test
    public void testNoKeytab() throws Throwable {
        this.kdiagFailure("KERBEROS", "--keylen", KEYLEN, "--keytab", "target/nofile");
    }

    @Test
    public void testKeytabNoPrincipal() throws Throwable {
        this.kdiagFailure("KERBEROS", "--keylen", KEYLEN, "--keytab", keytab.getAbsolutePath());
    }

    @Test
    public void testConfIsSecure() throws Throwable {
        Assert.assertFalse((boolean)SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE));
    }

    @Test
    public void testKeytabAndPrincipal() throws Throwable {
        this.kdiag("--keylen", KEYLEN, "--keytab", keytab.getAbsolutePath(), "--principal", "foo@EXAMPLE.COM");
    }

    @Test
    public void testKerberosName() throws Throwable {
        this.kdiagFailure("--keylen", KEYLEN, "--verifyshortname", "--principal", "foo/foo/foo@BAR.COM");
    }

    @Test
    public void testShortName() throws Throwable {
        this.kdiag("--keylen", KEYLEN, "--keytab", keytab.getAbsolutePath(), "--principal", "--verifyshortname", "--principal", "foo@EXAMPLE.COM");
    }

    @Test
    public void testFileOutput() throws Throwable {
        File f = new File("target/kdiag.txt");
        this.kdiag("--keylen", KEYLEN, "--keytab", keytab.getAbsolutePath(), "--principal", "foo@EXAMPLE.COM", "--out", f.getAbsolutePath());
        LOG.info("Output of {}", (Object)f);
        this.dump(f);
    }

    @Test
    public void testLoadResource() throws Throwable {
        this.kdiag("--keylen", KEYLEN, "--resource", HDFS_SITE_XML, "--keytab", keytab.getAbsolutePath(), "--principal", "foo@EXAMPLE.COM");
    }

    @Test
    public void testLoadInvalidResource() throws Throwable {
        this.kdiagFailure("CONFIG", "--keylen", KEYLEN, "--resource", "no-such-resource.xml", "--keytab", keytab.getAbsolutePath(), "--principal", "foo@EXAMPLE.COM");
    }

    @Test
    public void testRequireJAAS() throws Throwable {
        this.kdiagFailure("JAAS", "--keylen", KEYLEN, "--jaas", "--keytab", keytab.getAbsolutePath(), "--principal", "foo@EXAMPLE.COM");
    }

    private void dump(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            for (String line : IOUtils.readLines((InputStream)in)) {
                LOG.info(line);
            }
        }
    }
}

