/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;

public class HopsSSLTestUtils {
    private final Log LOG = LogFactory.getLog(HopsSSLTestUtils.class);
    protected CERT_ERR error_mode = CERT_ERR.ERR_CN;
    protected String passwd = "123456";
    private String outDir;
    private Path serverKeyStore;
    private Path serverTrustStore;
    private Path c_clientKeyStore;
    private Path c_clientTrustStore;
    protected Path err_clientKeyStore;
    protected Path err_clientTrustStore;
    protected List<Path> filesToPurge;
    protected Configuration conf;
    protected Thread invoker;
    @Rule
    public final ExpectedException rule = ExpectedException.none();
    protected static final String KEY_ALG = "RSA";
    protected static final String SIGN_ALG = "SHA256withRSA";

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({CERT_ERR.ERR_CN}, {CERT_ERR.NO_CA});
    }

    @After
    public void destroy() throws Exception {
        if (null != this.filesToPurge) {
            this.purgeFiles(this.filesToPurge);
        }
    }

    private void purgeFiles(List<Path> files) throws Exception {
        for (Path path : files) {
            File file = new File(path.toUri());
            if (!file.exists()) continue;
            file.delete();
        }
    }

    protected void setCryptoConfig(Configuration conf, String classPathDir) throws Exception {
        conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.HopsSSLSocketFactory");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        conf.set("hadoop.ssl.enabled.protocols", "TLSv1.2,TLSv1.1");
        conf.set("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
        String user = UserGroupInformation.getCurrentUser().getUserName();
        conf.set("hadoop.proxyuser." + user, "*");
        Configuration sslServerConf = KeyStoreTestUtil.createServerSSLConfig(this.serverKeyStore.toString(), this.passwd, this.passwd, this.serverTrustStore.toString(), this.passwd, "");
        Path sslServerPath = Paths.get(classPathDir, HopsSSLTestUtils.class.getSimpleName() + ".ssl-server.xml");
        this.filesToPurge.add(sslServerPath);
        File sslServer = new File(sslServerPath.toUri());
        KeyStoreTestUtil.saveConfig(sslServer, sslServerConf);
        conf.set("hadoop.ssl.server.conf", HopsSSLTestUtils.class.getSimpleName() + ".ssl-server.xml");
        conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), this.c_clientKeyStore.toString());
        conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), this.passwd);
        conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue(), this.passwd);
        conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), this.c_clientTrustStore.toString());
        conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), this.passwd);
        conf.set(HopsSSLSocketFactory.CryptoKeys.SOCKET_ENABLED_PROTOCOL.getValue(), "TLSv1.2");
    }

    protected Pair<KeyPair, X509Certificate> generateCAMaterial(String subject) throws GeneralSecurityException {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair(KEY_ALG);
        X509Certificate x509 = KeyStoreTestUtil.generateCertificate(subject, keyPair, 42, SIGN_ALG);
        return new Pair((Object)keyPair, (Object)x509);
    }

    protected List<Path> prepareCryptoMaterial(String outDir) throws Exception {
        return this.prepareCryptoMaterial(outDir, this.generateCAMaterial("CN=CARoot"));
    }

    protected List<Path> prepareCryptoMaterial(String outDir, Pair<KeyPair, X509Certificate> caMaterial) throws Exception {
        ArrayList<Path> filesToPurge = new ArrayList<Path>();
        this.outDir = outDir;
        KeyPair caKeyPair = (KeyPair)caMaterial.getFirst();
        X509Certificate caCert = (X509Certificate)caMaterial.getSecond();
        KeyPair serverKeyPair = KeyStoreTestUtil.generateKeyPair(KEY_ALG);
        X509Certificate serverCrt = KeyStoreTestUtil.generateSignedCertificate("CN=serverCrt", serverKeyPair, 42, SIGN_ALG, caKeyPair.getPrivate(), caCert);
        this.serverKeyStore = Paths.get(outDir, "server.keystore.jks");
        this.serverTrustStore = Paths.get(outDir, "server.truststore.jks");
        filesToPurge.add(this.serverKeyStore);
        filesToPurge.add(this.serverTrustStore);
        KeyStoreTestUtil.createKeyStore(this.serverKeyStore.toString(), this.passwd, this.passwd, "server_alias", serverKeyPair.getPrivate(), serverCrt);
        KeyStoreTestUtil.createTrustStore(this.serverTrustStore.toString(), this.passwd, "CARoot", caCert);
        KeyPair c_clientKeyPair = KeyStoreTestUtil.generateKeyPair(KEY_ALG);
        String c_cn = "CN=" + UserGroupInformation.getCurrentUser().getUserName();
        X509Certificate c_clientCrt = KeyStoreTestUtil.generateSignedCertificate(c_cn, c_clientKeyPair, 42, SIGN_ALG, caKeyPair.getPrivate(), caCert);
        this.c_clientKeyStore = Paths.get(outDir, "c_client.keystore.jks");
        this.c_clientTrustStore = Paths.get(outDir, "c_client.truststore.jks");
        filesToPurge.add(this.c_clientKeyStore);
        filesToPurge.add(this.c_clientTrustStore);
        KeyStoreTestUtil.createKeyStore(this.c_clientKeyStore.toString(), this.passwd, this.passwd, "c_client_alias", c_clientKeyPair.getPrivate(), c_clientCrt);
        KeyStoreTestUtil.createTrustStore(this.c_clientTrustStore.toString(), this.passwd, "CARoot", caCert);
        if (this.error_mode.equals((Object)CERT_ERR.NO_CA)) {
            this.LOG.info((Object)"no ca error mode");
            KeyPair noCA_clientKeyPair = KeyStoreTestUtil.generateKeyPair(KEY_ALG);
            X509Certificate noCA_clientCrt = KeyStoreTestUtil.generateCertificate(c_cn, noCA_clientKeyPair, 42, SIGN_ALG);
            this.err_clientKeyStore = Paths.get(outDir, "noCA_client.keystore.jks");
            this.err_clientTrustStore = Paths.get(outDir, "noCA_client.truststore.jks");
            filesToPurge.add(this.err_clientKeyStore);
            filesToPurge.add(this.err_clientTrustStore);
            KeyStoreTestUtil.createKeyStore(this.err_clientKeyStore.toString(), this.passwd, this.passwd, "noca_client_alias", noCA_clientKeyPair.getPrivate(), noCA_clientCrt);
            KeyStoreTestUtil.createTrustStore(this.err_clientTrustStore.toString(), this.passwd, "CARoot", caCert);
        } else if (this.error_mode.equals((Object)CERT_ERR.ERR_CN)) {
            this.LOG.info((Object)"wrong cn error mode");
            KeyPair errCN_clientKeyPair = KeyStoreTestUtil.generateKeyPair(KEY_ALG);
            X509Certificate errCN_clientCrt = KeyStoreTestUtil.generateSignedCertificate("CN=Phil Lynott", errCN_clientKeyPair, 42, SIGN_ALG, caKeyPair.getPrivate(), caCert);
            this.err_clientKeyStore = Paths.get(outDir, "errCN_client.keystore.jks");
            this.err_clientTrustStore = Paths.get(outDir, "errCN_client.truststore.jks");
            filesToPurge.add(this.err_clientKeyStore);
            filesToPurge.add(this.err_clientTrustStore);
            KeyStoreTestUtil.createKeyStore(this.err_clientKeyStore.toString(), this.passwd, this.passwd, "errcn_client_alias", errCN_clientKeyPair.getPrivate(), errCN_clientCrt);
            KeyStoreTestUtil.createTrustStore(this.err_clientTrustStore.toString(), this.passwd, "CARoot", caCert);
        }
        return filesToPurge;
    }

    protected static enum CERT_ERR {
        ERR_CN,
        NO_CA,
        NO_ERROR;

    }
}

