/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.security.UsersGroupsCache;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class UsersGroups {
    private static final Log LOG = LogFactory.getLog(UsersGroups.class);
    private static UsersGroupsCache usersGroupsMapping;

    public static synchronized void init(UserDataAccess uda, UserGroupDataAccess ugda, GroupDataAccess gda, int evcttime, int lrumax) {
        if (usersGroupsMapping == null) {
            LOG.info((Object)"UsersGroups Initialized.");
            usersGroupsMapping = new UsersGroupsCache(uda, ugda, gda, evcttime, lrumax);
        }
    }

    public static List<String> getGroups(String user) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return null;
        }
        return usersGroupsMapping.getGroups(user);
    }

    public static int getGroupID(String groupName) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return 0;
        }
        return usersGroupsMapping.getGroupId(groupName);
    }

    public static int getUserID(String userName) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return 0;
        }
        return usersGroupsMapping.getUserId(userName);
    }

    public static String getUser(int userId) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return null;
        }
        return usersGroupsMapping.getUserName(userId);
    }

    public static String getGroup(int groupId) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return null;
        }
        return usersGroupsMapping.getGroupName(groupId);
    }

    public static void removeUserFromGroupTx(String user, String group, boolean cacheOnly) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.removeUserFromGroupTx(user, group, cacheOnly);
    }

    public static void addUserToGroupTx(String user, String group, boolean cacheOnly) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.addUserToGroupTx(user, group, cacheOnly);
    }

    public static void addUserToGroupTx(String user, String group) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.addUserToGroupTx(user, group);
    }

    public static void addUserToGroupsTx(String user, String[] groups) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.addUserToGroupsTx(user, groups);
    }

    public static void addUserToGroup(String user, String group) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.addUserToGroup(user, group);
    }

    public static void addUserToGroups(String user, String[] groups) throws IOException {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.addUserToGroups(user, groups);
    }

    public static void removeUserFromCache(String userName) {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.removeUserFromCache(userName);
    }

    public static void removeGroupFromCache(String groupName) {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.removeGroupFromCache(groupName);
    }

    public static void clearCache() {
        if (usersGroupsMapping == null) {
            LOG.warn((Object)"UsersGroups was not initialized.");
            return;
        }
        usersGroupsMapping.clear();
    }

    @VisibleForTesting
    public static void stop() {
        if (usersGroupsMapping != null) {
            usersGroupsMapping.clear();
            usersGroupsMapping = null;
        }
    }
}

