/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import io.hops.exception.ForeignKeyConstraintViolationException;
import io.hops.exception.StorageException;
import io.hops.exception.UniqueKeyConstraintViolationException;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.entity.Group;
import io.hops.metadata.hdfs.entity.User;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
@VisibleForTesting
class UsersGroupsCache {
    private final Log LOG = LogFactory.getLog(UsersGroupsCache.class);
    private LoadingCache<String, List<String>> usersToGroups;
    private Cache<String, List<String>> groupsToUsers;
    private LoadingCache<Integer, String> idsToUsers;
    private LoadingCache<String, Integer> usersToIds;
    private LoadingCache<Integer, String> idsToGroups;
    private LoadingCache<String, Integer> groupsToIds;
    private CacheLoader<String, List<String>> usersToGroupsLoader = new CacheLoader<String, List<String>>(){

        public List<String> load(String userName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get groups from DB for user=" + userName));
            List groups = UsersGroupsCache.this.getGroupsFromDB(userName, UsersGroupsCache.this.getUserId(userName));
            if (groups == null || groups.isEmpty()) {
                throw new GroupsNotFoundForUserException("No groups found for user (" + userName + ")");
            }
            ArrayList groupNames = Lists.newArrayListWithExpectedSize((int)groups.size());
            for (Group group : groups) {
                groupNames.add(group.getName());
                UsersGroupsCache.this.addGroupToCache(group.getId(), group.getName());
                ArrayList<String> users = (ArrayList<String>)UsersGroupsCache.this.groupsToUsers.getIfPresent((Object)group.getName());
                if (users == null) {
                    users = new ArrayList<String>();
                    UsersGroupsCache.this.groupsToUsers.put((Object)group.getName(), users);
                }
                users.add(userName);
            }
            return groupNames;
        }
    };
    private RemovalListener<String, List<String>> usersToGroupsRemoval = new RemovalListener<String, List<String>>(){

        public void onRemoval(RemovalNotification<String, List<String>> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User's groups removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
            List groups = (List)rn.getValue();
            for (String group : groups) {
                List users = (List)UsersGroupsCache.this.groupsToUsers.getIfPresent((Object)group);
                if (users == null) continue;
                users.remove(rn.getKey());
                if (!users.isEmpty()) continue;
                UsersGroupsCache.this.groupsToUsers.invalidate((Object)group);
            }
        }
    };
    private RemovalListener<String, List<String>> groupsToUsersRemoval = new RemovalListener<String, List<String>>(){

        public void onRemoval(RemovalNotification<String, List<String>> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group's users removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
            List users = (List)rn.getValue();
            for (String user : users) {
                List groups = (List)UsersGroupsCache.this.usersToGroups.getIfPresent((Object)user);
                if (groups == null) continue;
                groups.remove(rn.getKey());
                if (!groups.isEmpty()) continue;
                UsersGroupsCache.this.usersToGroups.invalidate((Object)user);
            }
        }
    };
    private CacheLoader<Integer, String> usersByIdLoader = new CacheLoader<Integer, String>(){

        public String load(Integer userId) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get user from DB by id=" + userId));
            User user = UsersGroupsCache.this.getUserFromDB(null, userId);
            if (user != null) {
                UsersGroupsCache.this.usersToIds.put((Object)user.getName(), (Object)userId);
                return user.getName();
            }
            throw new UserNotFoundException("User (" + userId + ") was not found.");
        }
    };
    private RemovalListener<Integer, String> usersByIdRemoval = new RemovalListener<Integer, String>(){

        public void onRemoval(RemovalNotification<Integer, String> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
            UsersGroupsCache.this.usersToIds.invalidate(rn.getValue());
        }
    };
    private CacheLoader<String, Integer> usersByNameLoader = new CacheLoader<String, Integer>(){

        public Integer load(String userName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get user from DB by name=" + userName));
            User user = UsersGroupsCache.this.getUserFromDB(userName, null);
            if (user != null) {
                UsersGroupsCache.this.idsToUsers.put((Object)user.getId(), (Object)userName);
                return user.getId();
            }
            throw new UserNotFoundException("User (" + userName + ") was not found.");
        }
    };
    private RemovalListener<String, Integer> usersByNameRemoval = new RemovalListener<String, Integer>(){

        public void onRemoval(RemovalNotification<String, Integer> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("User removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
            UsersGroupsCache.this.idsToUsers.invalidate(rn.getValue());
        }
    };
    private CacheLoader<Integer, String> groupsByIdLoader = new CacheLoader<Integer, String>(){

        public String load(Integer groupId) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get group from DB by id=" + groupId));
            Group group = UsersGroupsCache.this.getGroupFromDB(null, groupId);
            if (group != null) {
                UsersGroupsCache.this.groupsToIds.put((Object)group.getName(), (Object)groupId);
                return group.getName();
            }
            throw new GroupNotFoundException("Group (" + groupId + ") was not found.");
        }
    };
    private RemovalListener<Integer, String> groupsByIdRemoval = new RemovalListener<Integer, String>(){

        public void onRemoval(RemovalNotification<Integer, String> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
            UsersGroupsCache.this.groupsToIds.invalidate(rn.getValue());
        }
    };
    private CacheLoader<String, Integer> groupsByNameLoader = new CacheLoader<String, Integer>(){

        public Integer load(String groupName) throws Exception {
            UsersGroupsCache.this.LOG.debug((Object)("Get group from DB by name=" + groupName));
            Group group = UsersGroupsCache.this.getGroupFromDB(groupName, null);
            if (group != null) {
                UsersGroupsCache.this.idsToGroups.put((Object)group.getId(), (Object)groupName);
                return group.getId();
            }
            throw new GroupNotFoundException("Group (" + groupName + ") was not found.");
        }
    };
    private RemovalListener<String, Integer> groupsByNameRemoval = new RemovalListener<String, Integer>(){

        public void onRemoval(RemovalNotification<String, Integer> rn) {
            UsersGroupsCache.this.LOG.debug((Object)("Group removal notification for " + rn.toString() + "(" + rn.getCause() + ")"));
            UsersGroupsCache.this.idsToGroups.invalidate(rn.getValue());
        }
    };
    private final UserGroupDataAccess userGroupDataAccess;
    private final GroupDataAccess<Group> groupDataAccess;
    private final UserDataAccess<User> userDataAccess;
    private final boolean isConfigured;

    public UsersGroupsCache(UserDataAccess uda, UserGroupDataAccess ugda, GroupDataAccess gda, int evectionTime, int lrumax) {
        this.userDataAccess = uda;
        this.userGroupDataAccess = ugda;
        this.groupDataAccess = gda;
        this.usersToGroups = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.usersToGroupsRemoval).build(this.usersToGroupsLoader);
        this.groupsToUsers = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.groupsToUsersRemoval).build();
        this.idsToUsers = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.usersByIdRemoval).build(this.usersByIdLoader);
        this.usersToIds = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.usersByNameRemoval).build(this.usersByNameLoader);
        this.idsToGroups = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.groupsByIdRemoval).build(this.groupsByIdLoader);
        this.groupsToIds = CacheBuilder.newBuilder().maximumSize((long)lrumax).expireAfterWrite((long)evectionTime, TimeUnit.SECONDS).removalListener(this.groupsByNameRemoval).build(this.groupsByNameLoader);
        this.isConfigured = this.userDataAccess != null && this.userGroupDataAccess != null && this.groupDataAccess != null;
    }

    void addUser(String userName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (userName == null) {
            return;
        }
        this.LOG.debug((Object)("Add user to DB name=" + userName));
        User user = this.addUserToDB(userName);
        this.LOG.debug((Object)("User Added " + user));
        this.addUserToCache(user.getId(), user.getName());
    }

    private void addUserToCache(Integer userId, String userName) {
        this.idsToUsers.put((Object)userId, (Object)userName);
        this.usersToIds.put((Object)userName, (Object)userId);
    }

    void removeUser(String userName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (userName == null) {
            return;
        }
        this.LOG.debug((Object)("Remove user from DB name=" + userName));
        Integer userId = this.getUserId(userName);
        this.removeUserFromDB(userId);
        this.removeUserFromCache(userId, userName);
    }

    void removeUserFromCache(String userName) {
        this.removeUserFromCache((Integer)this.usersToIds.getIfPresent((Object)userName), userName);
    }

    private void removeUserFromCache(Integer userId, String userName) {
        this.idsToUsers.invalidate((Object)userId);
        this.usersToIds.invalidate((Object)userName);
        this.usersToGroups.invalidate((Object)userName);
    }

    int getUserId(String userName) throws IOException {
        if (!this.isConfigured) {
            return 0;
        }
        if (userName == null) {
            return 0;
        }
        try {
            return (Integer)this.usersToIds.get((Object)userName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException) {
                return 0;
            }
            throw new IOException(e);
        }
    }

    Integer getUserIdFromCache(String userName) {
        if (userName == null) {
            return 0;
        }
        return (Integer)this.usersToIds.getIfPresent((Object)userName);
    }

    String getUserName(Integer userId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (userId == null || userId <= 0) {
            return null;
        }
        try {
            return (String)this.idsToUsers.get((Object)userId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UserNotFoundException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    void addGroup(String groupName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (groupName == null) {
            return;
        }
        this.LOG.debug((Object)("Add group to DB name=" + groupName));
        Group group = this.addGroupToDB(groupName);
        this.LOG.debug((Object)("Group Added " + group));
        this.addGroupToCache(group.getId(), group.getName());
    }

    private void addGroupToCache(Integer groupId, String groupName) {
        this.idsToGroups.put((Object)groupId, (Object)groupName);
        this.groupsToIds.put((Object)groupName, (Object)groupId);
    }

    void removeGroup(String groupName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (groupName == null) {
            return;
        }
        this.LOG.debug((Object)("Remove group from DB name=" + groupName));
        Integer groupId = this.getGroupId(groupName);
        this.removeGroupFromDB(groupId);
        this.removeGroupFromCache(groupId, groupName);
    }

    void removeGroupFromCache(String groupName) {
        this.removeGroupFromCache((Integer)this.groupsToIds.getIfPresent((Object)groupName), groupName);
    }

    private void removeGroupFromCache(Integer groupId, String groupName) {
        this.idsToGroups.invalidate((Object)groupId);
        this.groupsToIds.invalidate((Object)groupName);
        this.groupsToUsers.invalidate((Object)groupName);
    }

    int getGroupId(String groupName) throws IOException {
        if (!this.isConfigured) {
            return 0;
        }
        if (groupName == null) {
            return 0;
        }
        try {
            return (Integer)this.groupsToIds.get((Object)groupName);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                return 0;
            }
            throw new IOException(e);
        }
    }

    Integer getGroupIdFromCache(String groupName) {
        if (groupName == null) {
            return 0;
        }
        return (Integer)this.groupsToIds.getIfPresent((Object)groupName);
    }

    String getGroupName(Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (groupId == null || groupId <= 0) {
            return null;
        }
        try {
            return (String)this.idsToGroups.get((Object)groupId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupNotFoundException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    void removeUserFromGroup(String userName, String groupName) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        if (userName == null || groupName == null) {
            return;
        }
        this.LOG.debug((Object)("Remove user-group from DB user=" + userName + ", group=" + groupName));
        Integer userId = this.getUserId(userName);
        Integer groupId = this.getGroupId(groupName);
        this.removeUserFromGroupFromDB(userId, groupId);
        this.removeUserFromGroupInCache(userName, groupName);
    }

    List<String> getGroups(String user) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        if (user == null) {
            return null;
        }
        try {
            return (List)this.usersToGroups.get((Object)user);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof GroupsNotFoundForUserException) {
                return null;
            }
            throw new IOException(e);
        }
    }

    List<String> getGroupsFromCache(String user) throws IOException {
        if (user == null) {
            return null;
        }
        return (List)this.usersToGroups.getIfPresent((Object)user);
    }

    void removeUserFromGroupTx(String user, String group, boolean cacheOnly) throws IOException {
        if (cacheOnly) {
            if (user != null && group == null) {
                this.removeUserFromCache(user);
            } else if (user == null && group != null) {
                this.removeGroupFromCache(group);
            } else if (user != null && group != null) {
                this.removeUserFromGroupInCache(user, group);
            }
        } else if (user != null && group == null) {
            this.removeUser(user);
        } else if (user == null && group != null) {
            this.removeGroup(group);
        } else if (user != null && group != null) {
            this.removeUserFromGroup(user, group);
        }
    }

    void addUserToGroupTx(String user, String group, boolean cacheOnly) throws IOException {
        if (cacheOnly) {
            if (user != null && group != null) {
                this.addUserToGroupsInCache(user, Arrays.asList(group));
            }
        } else {
            this.addUserToGroupTx(user, group);
        }
    }

    void addUserToGroupTx(String user, String group) throws IOException {
        this.addUserToGroupsTx(user, new String[]{group});
    }

    void addUserToGroup(String user, String group) throws IOException {
        this.addUserToGroups(user, new String[]{group});
    }

    void addUserToGroupsTx(String user, String[] groups) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        try {
            this.addUserToGroupsInternalTx(user, groups);
        }
        catch (ForeignKeyConstraintViolationException ex) {
            this.removeUserFromCache(user);
            for (String group : groups) {
                this.removeGroupFromCache(group);
            }
            this.addUserToGroupsInternalTx(user, groups);
        }
        catch (UniqueKeyConstraintViolationException ex) {
            this.LOG.debug((Object)("User/Group was already added: " + (Object)((Object)ex)));
        }
    }

    private void addUserToGroupsInternalTx(final String user, final String[] grps) throws IOException {
        new LightWeightRequestHandler(UsersOperationsType.ADD_USER_GROUPS){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.addUserToGroups(user, grps);
                return null;
            }
        }.handle();
    }

    void addUserToGroups(String user, String[] grps) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        this.LOG.debug((Object)("Add user (" + user + ") to groups " + grps));
        Collection groups = null;
        if (grps != null) {
            groups = Collections2.filter(Arrays.asList(grps), (Predicate)Predicates.notNull());
        }
        Integer userId = null;
        if (user != null) {
            List availableGroups = (List)this.usersToGroups.getIfPresent((Object)user);
            if (availableGroups != null && groups != null && availableGroups.containsAll(groups)) {
                this.LOG.debug((Object)("Groups (" + grps + ") already available in the cache for user (" + user + ")"));
                return;
            }
            userId = (Integer)this.usersToIds.getIfPresent((Object)user);
            if (userId == null) {
                this.addUser(user);
                userId = this.getUserId(user);
            }
        }
        if (groups != null) {
            ArrayList groupIds = Lists.newArrayList();
            for (String group : groups) {
                Integer groupId = (Integer)this.groupsToIds.getIfPresent((Object)group);
                if (groupId == null) {
                    this.addGroup(group);
                    groupId = this.getGroupId(group);
                }
                groupIds.add(groupId);
            }
            if (userId != null) {
                this.userGroupDataAccess.addUserToGroups(userId.intValue(), (List)groupIds);
                this.addUserToGroupsInCache(user, groups);
            }
        }
    }

    void addUserToGroupsInCache(String user, Collection<String> groups) {
        ArrayList currentGroups = (ArrayList)this.usersToGroups.getIfPresent((Object)user);
        if (currentGroups == null) {
            currentGroups = new ArrayList();
            this.usersToGroups.put((Object)user, currentGroups);
        }
        HashSet<String> newGroups = new HashSet<String>();
        newGroups.addAll(groups);
        newGroups.removeAll(currentGroups);
        for (String group : newGroups) {
            ArrayList<String> users = (ArrayList<String>)this.groupsToUsers.getIfPresent((Object)group);
            if (users == null) {
                users = new ArrayList<String>();
                this.groupsToUsers.put((Object)group, users);
            }
            users.add(user);
        }
        currentGroups.addAll(newGroups);
    }

    void removeUserFromGroupInCache(String user, String group) {
        List currentGroups = (List)this.usersToGroups.getIfPresent((Object)user);
        if (currentGroups == null) {
            return;
        }
        currentGroups.remove(group);
        if (currentGroups.isEmpty()) {
            this.usersToGroups.invalidate((Object)user);
        }
    }

    void clear() {
        this.usersToGroups.invalidateAll();
        this.groupsToUsers.invalidateAll();
        this.idsToUsers.invalidateAll();
        this.usersToIds.invalidateAll();
        this.idsToGroups.invalidateAll();
        this.groupsToIds.invalidateAll();
    }

    private User getUserFromDB(final String userName, final Integer userId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (User)new LightWeightRequestHandler(UsersOperationsType.GET_USER){

            public Object performTask() throws StorageException, IOException {
                return userName == null ? (User)UsersGroupsCache.this.userDataAccess.getUser(userId.intValue()) : (User)UsersGroupsCache.this.userDataAccess.getUser(userName);
            }
        }.handle();
    }

    private User addUserToDB(final String userName) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (User)new LightWeightRequestHandler(UsersOperationsType.ADD_USER){

            public Object performTask() throws StorageException, IOException {
                return UsersGroupsCache.this.userDataAccess.addUser(userName);
            }
        }.handle();
    }

    private void removeUserFromDB(final Integer userId) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_USER){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.userDataAccess.removeUser(userId.intValue());
                return null;
            }
        }.handle();
    }

    private Group getGroupFromDB(final String groupName, final Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (Group)new LightWeightRequestHandler(UsersOperationsType.GET_GROUP){

            public Object performTask() throws StorageException, IOException {
                return groupName == null ? (Group)UsersGroupsCache.this.groupDataAccess.getGroup(groupId.intValue()) : (Group)UsersGroupsCache.this.groupDataAccess.getGroup(groupName);
            }
        }.handle();
    }

    private Group addGroupToDB(final String groupName) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (Group)new LightWeightRequestHandler(UsersOperationsType.ADD_GROUP){

            public Object performTask() throws StorageException, IOException {
                return UsersGroupsCache.this.groupDataAccess.addGroup(groupName);
            }
        }.handle();
    }

    private void removeGroupFromDB(final Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_GROUP){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.groupDataAccess.removeGroup(groupId.intValue());
                return null;
            }
        }.handle();
    }

    private void removeUserFromGroupFromDB(final Integer userId, final Integer groupId) throws IOException {
        if (!this.isConfigured) {
            return;
        }
        new LightWeightRequestHandler(UsersOperationsType.REMOVE_USER_GROUPS){

            public Object performTask() throws StorageException, IOException {
                UsersGroupsCache.this.userGroupDataAccess.removeUserFromGroup(userId.intValue(), groupId.intValue());
                return null;
            }
        }.handle();
    }

    private List<Group> getGroupsFromDB(final String userName, final Integer userId) throws IOException {
        if (!this.isConfigured) {
            return null;
        }
        return (List)new LightWeightRequestHandler(UsersOperationsType.GET_USER_GROUPS){

            public Object performTask() throws StorageException, IOException {
                User user;
                List result = null;
                boolean transactionActive = connector.isTransactionActive();
                if (!transactionActive) {
                    connector.beginTransaction();
                }
                User user2 = user = userId == null ? (User)UsersGroupsCache.this.userDataAccess.getUser(userName) : (User)UsersGroupsCache.this.userDataAccess.getUser(userId.intValue());
                if (user != null) {
                    List groups;
                    result = groups = UsersGroupsCache.this.userGroupDataAccess.getGroupsForUser(user.getId());
                }
                if (!transactionActive) {
                    connector.commit();
                }
                return result;
            }
        }.handle();
    }

    private class GroupsNotFoundForUserException
    extends Exception {
        public GroupsNotFoundForUserException(String message) {
            super(message);
        }
    }

    private class GroupNotFoundException
    extends Exception {
        public GroupNotFoundException(String message) {
            super(message);
        }
    }

    private class UserNotFoundException
    extends Exception {
        public UserNotFoundException(String message) {
            super(message);
        }
    }

    private static enum UsersOperationsType implements RequestHandler.OperationType
    {
        ADD_USER,
        REMOVE_USER,
        ADD_GROUP,
        REMOVE_GROUP,
        GET_USER_GROUPS,
        GET_USER,
        GET_GROUP,
        ADD_USER_GROUPS,
        REMOVE_USER_GROUPS;

    }
}

