/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CommonConfigurationKeys;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public final class CodecUtil {
    private CodecUtil() {
    }

    public static RawErasureEncoder createRawEncoder(Configuration conf, String codec, ErasureCoderOptions coderOptions) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)codec);
        String rawCoderFactoryKey = CodecUtil.getFactNameFromCodec(conf, codec);
        RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(conf, rawCoderFactoryKey);
        return fact.createEncoder(coderOptions);
    }

    public static RawErasureDecoder createRawDecoder(Configuration conf, String codec, ErasureCoderOptions coderOptions) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkNotNull((Object)codec);
        String rawCoderFactoryKey = CodecUtil.getFactNameFromCodec(conf, codec);
        RawErasureCoderFactory fact = CodecUtil.createRawCoderFactory(conf, rawCoderFactoryKey);
        return fact.createDecoder(coderOptions);
    }

    private static RawErasureCoderFactory createRawCoderFactory(Configuration conf, String rawCoderFactoryKey) {
        RawErasureCoderFactory fact;
        try {
            Class<RawErasureCoderFactory> factClass = conf.getClassByName(rawCoderFactoryKey).asSubclass(RawErasureCoderFactory.class);
            fact = factClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to create raw coder factory", e);
        }
        if (fact == null) {
            throw new RuntimeException("Failed to create raw coder factory");
        }
        return fact;
    }

    private static String getFactNameFromCodec(Configuration conf, String codec) {
        switch (codec) {
            case "rs-default": {
                return conf.get("io.erasurecode.codec.rs-default.rawcoder", CommonConfigurationKeys.IO_ERASURECODE_CODEC_RS_DEFAULT_RAWCODER_DEFAULT);
            }
            case "rs-legacy": {
                return conf.get("io.erasurecode.codec.rs-legacy.rawcoder", CommonConfigurationKeys.IO_ERASURECODE_CODEC_RS_LEGACY_RAWCODER_DEFAULT);
            }
            case "xor": {
                return conf.get("io.erasurecode.codec.xor.rawcoder", CommonConfigurationKeys.IO_ERASURECODE_CODEC_XOR_RAWCODER_DEFAULT);
            }
        }
        String rawCoderKey = "io.erasurecode.codec." + codec + ".rawcoder";
        String factName = conf.get(rawCoderKey);
        if (factName == null) {
            throw new IllegalArgumentException("Raw coder factory not configured for custom codec " + codec);
        }
        return factName;
    }
}

