/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.RpcSSLEngineAbstr;
import org.apache.hadoop.ipc.Server;

public class ServerRpcSSLEngineImpl
extends RpcSSLEngineAbstr {
    private final Log LOG = LogFactory.getLog(ServerRpcSSLEngineImpl.class);
    private final int KB = 1024;
    private final int MB = 0x100000;
    private final int MAX_BUFFER_SIZE = 0x500000;
    private final int maxUnWrappedDataLength;

    public ServerRpcSSLEngineImpl(SocketChannel socketChannel, SSLEngine sslEngine, int maxUnwrappedDataLength) {
        super(socketChannel, sslEngine);
        this.maxUnWrappedDataLength = maxUnwrappedDataLength;
    }

    @Override
    public int write(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        this.serverAppBuffer.clear();
        if (this.serverAppBuffer.capacity() < buffer.capacity()) {
            this.LOG.error((Object)("ServerAppBuffer capacity: " + this.serverAppBuffer.capacity() + " Buffer size: " + buffer.capacity()));
            this.serverAppBuffer = ByteBuffer.allocate(Math.min(buffer.capacity(), 0x500000));
        }
        this.serverAppBuffer.put(buffer);
        this.serverAppBuffer.flip();
        int bytesWritten = 0;
        block6: while (this.serverAppBuffer.hasRemaining()) {
            this.serverNetBuffer.clear();
            SSLEngineResult result = this.sslEngine.wrap(this.serverAppBuffer, this.serverNetBuffer);
            switch (result.getStatus()) {
                case OK: {
                    this.serverNetBuffer.flip();
                    while (this.serverNetBuffer.hasRemaining()) {
                        bytesWritten += channel.write(this.serverNetBuffer);
                    }
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    this.serverNetBuffer = this.enlargePacketBuffer(this.serverNetBuffer);
                    continue block6;
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow should not happen after wrap");
                }
                case CLOSED: {
                    this.sslEngine.closeOutbound();
                    this.doHandshake();
                    return -1;
                }
            }
            throw new IllegalStateException("Invalid SSL state: " + (Object)((Object)result.getStatus()));
        }
        return bytesWritten;
    }

    @Override
    public int read(ReadableByteChannel channel, ByteBuffer buffer, Server.Connection connection) throws IOException {
        int netRead = channel.read(this.clientNetBuffer);
        if (netRead == -1) {
            return -1;
        }
        int read = 0;
        do {
            this.clientNetBuffer.flip();
            SSLEngineResult unwrapResult = this.sslEngine.unwrap(this.clientNetBuffer, this.clientAppBuffer);
            this.clientNetBuffer.compact();
            if (unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.OK)) {
                read += unwrapResult.bytesProduced();
                this.clientAppBuffer.flip();
                while (this.clientAppBuffer.hasRemaining()) {
                    byte currentByte = this.clientAppBuffer.get();
                    try {
                        buffer.put(currentByte);
                    }
                    catch (BufferOverflowException ex) {
                        if (buffer.capacity() < this.maxUnWrappedDataLength) {
                            buffer = this.enlargeUnwrappedBuffer(buffer, currentByte);
                            connection.setSslUnwrappedBuffer(buffer);
                            continue;
                        }
                        this.LOG.error((Object)("Buffer overflow clientAppBuffer position: " + this.clientAppBuffer.position() + " but buffer capacity " + buffer.capacity()), (Throwable)ex);
                        throw ex;
                    }
                }
                this.clientAppBuffer.compact();
                continue;
            }
            if (unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
                read += unwrapResult.bytesProduced();
                break;
            }
            if (unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_OVERFLOW)) {
                this.clientAppBuffer = this.enlargeApplicationBuffer(this.clientAppBuffer);
                continue;
            }
            if (unwrapResult.getStatus().equals((Object)SSLEngineResult.Status.CLOSED)) {
                this.sslEngine.closeOutbound();
                this.doHandshake();
                read = -1;
                break;
            }
            throw new IOException("SSLEngine UNWRAP invalid status: " + (Object)((Object)unwrapResult.getStatus()));
        } while (this.clientNetBuffer.position() != 0);
        return read;
    }

    public X509Certificate getClientCertificate() throws SSLPeerUnverifiedException {
        return (X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0];
    }

    private ByteBuffer enlargeUnwrappedBuffer(ByteBuffer buffer, byte missedByte) {
        buffer.flip();
        ByteBuffer newBuffer = ByteBuffer.allocate(Math.min(buffer.capacity() * 2, this.maxUnWrappedDataLength));
        newBuffer.put(buffer);
        newBuffer.put(missedByte);
        buffer = null;
        return newBuffer;
    }
}

