/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.LightWeightResizableGSet;
import org.junit.Assert;
import org.junit.Test;

public class TestLightWeightResizableGSet {
    public static final Log LOG = LogFactory.getLog(TestLightWeightResizableGSet.class);
    private Random random = new Random();

    private TestElement[] generateElements(int length) {
        TestElement[] elements = new TestElement[length];
        HashSet<Long> keys = new HashSet<Long>();
        long k = 0L;
        for (int i = 0; i < length; ++i) {
            while (keys.contains(k = this.random.nextLong())) {
            }
            elements[i] = new TestElement(k, this.random.nextLong());
            keys.add(k);
        }
        return elements;
    }

    private TestKey[] getKeys(TestElement[] elements) {
        TestKey[] keys = new TestKey[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            keys[i] = new TestKey(elements[i].getKey());
        }
        return keys;
    }

    private TestElement[] generateElements(TestKey[] keys) {
        TestElement[] elements = new TestElement[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            elements[i] = new TestElement(keys[i], this.random.nextLong());
        }
        return elements;
    }

    @Test(timeout=60000L)
    public void testBasicOperations() {
        Object element;
        int i;
        TestElement element2;
        int i2;
        TestElement[] elements = this.generateElements(65536);
        LightWeightResizableGSet set = new LightWeightResizableGSet();
        Assert.assertEquals((long)set.size(), (long)0L);
        for (i2 = 0; i2 < elements.length; ++i2) {
            element2 = (TestElement)set.put((Object)elements[i2]);
            Assert.assertTrue((element2 == null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)set.size(), (long)elements.length);
        for (i2 = 0; i2 < elements.length; ++i2) {
            Assert.assertTrue((boolean)set.contains((Object)elements[i2]));
            element2 = (TestElement)set.get((Object)elements[i2]);
            Assert.assertEquals((long)elements[i2].getData(), (long)element2.getData());
        }
        TestKey[] keys = this.getKeys(elements);
        TestElement[] newElements = this.generateElements(keys);
        for (i = 0; i < newElements.length; ++i) {
            element = (TestElement)set.put((Object)newElements[i]);
            Assert.assertTrue((element != null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)set.size(), (long)elements.length);
        for (i = 0; i < keys.length; ++i) {
            Assert.assertTrue((boolean)set.contains((Object)keys[i]));
            element = (TestElement)set.get((Object)keys[i]);
            Assert.assertEquals((long)newElements[i].getData(), (long)((TestElement)element).getData());
        }
        Collection cElements = set.values();
        Assert.assertEquals((long)cElements.size(), (long)elements.length);
        for (TestElement element3 : cElements) {
            Assert.assertTrue((boolean)set.contains((Object)element3));
        }
        for (int i3 = 0; i3 < keys.length; ++i3) {
            TestElement element3;
            element3 = (TestElement)set.remove((Object)keys[i3]);
            Assert.assertTrue((element3 != null ? 1 : 0) != 0);
            Assert.assertFalse((boolean)set.contains((Object)keys[i3]));
        }
        Assert.assertEquals((long)set.size(), (long)0L);
    }

    @Test(timeout=60000L)
    public void testRemoveAll() {
        TestElement element;
        int i;
        TestElement[] elements = this.generateElements(65536);
        LightWeightResizableGSet set = new LightWeightResizableGSet();
        Assert.assertEquals((long)set.size(), (long)0L);
        for (i = 0; i < elements.length; ++i) {
            element = (TestElement)set.put((Object)elements[i]);
            Assert.assertTrue((element == null ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)set.size(), (long)elements.length);
        set.clear();
        Assert.assertEquals((long)set.size(), (long)0L);
        for (i = 0; i < elements.length; ++i) {
            Assert.assertFalse((boolean)set.contains((Object)elements[i]));
        }
        Assert.assertFalse((boolean)set.iterator().hasNext());
        for (i = 0; i < elements.length; ++i) {
            element = (TestElement)set.put((Object)elements[i]);
            Assert.assertTrue((element == null ? 1 : 0) != 0);
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            element = (TestElement)iter.next();
            Assert.assertTrue((boolean)set.contains((Object)element));
            iter.remove();
            Assert.assertFalse((boolean)set.contains((Object)element));
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            Assert.assertFalse((boolean)set.contains((Object)elements[i2]));
        }
        Assert.assertFalse((boolean)set.iterator().hasNext());
        Assert.assertEquals((long)set.size(), (long)0L);
    }

    private static class TestElement
    extends TestKey
    implements LightWeightGSet.LinkedElement {
        private final long data;
        private LightWeightGSet.LinkedElement next;

        TestElement(long key, long data) {
            super(key);
            this.data = data;
        }

        TestElement(TestKey key, long data) {
            super(key);
            this.data = data;
        }

        long getData() {
            return this.data;
        }

        public void setNext(LightWeightGSet.LinkedElement next) {
            this.next = next;
        }

        public LightWeightGSet.LinkedElement getNext() {
            return this.next;
        }
    }

    private static class TestKey {
        private final long key;

        TestKey(long key) {
            this.key = key;
        }

        TestKey(TestKey other) {
            this.key = other.key;
        }

        long getKey() {
            return this.key;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestKey)) {
                return false;
            }
            TestKey other = (TestKey)o;
            return this.key == other.key;
        }
    }
}

