/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.CRLFetcher;
import org.apache.hadoop.security.ssl.CRLFetcherFactory;
import org.apache.hadoop.security.ssl.RevocationListFetcher;
import org.apache.hadoop.service.AbstractService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RevocationListFetcherService
extends AbstractService
implements RevocationListFetcher {
    private static final Logger LOG = LogManager.getLogger(RevocationListFetcherService.class);
    private CRLFetcher crlFetcher;
    private Thread fetcherThread;
    private long fetcherInterval;
    private TimeUnit intervalTimeUnit = TimeUnit.MINUTES;

    public RevocationListFetcherService() {
        super("CRL fetcher service");
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"Initializing CRL fetching service");
        this.crlFetcher = CRLFetcherFactory.getInstance().getCRLFetcher(conf);
        this.fetcherInterval = conf.getTimeDuration("hops.crl.fetcher.interval", 720L, this.intervalTimeUnit);
        if (this.intervalTimeUnit.equals((Object)TimeUnit.MINUTES) && this.fetcherInterval < 120L) {
            LOG.info((Object)("Configured fetcher interval is too low " + this.fetcherInterval + " falling back to 120 minutes"));
            this.fetcherInterval = 120L;
        }
        super.serviceInit(conf);
    }

    @Override
    public void serviceStart() throws Exception {
        LOG.info((Object)"Starting CRL fetching service");
        if (this.fetcherThread == null) {
            CountDownLatch readySignal = new CountDownLatch(1);
            this.fetcherThread = new FetcherThread(readySignal);
            this.fetcherThread.setDaemon(true);
            this.fetcherThread.setName("CRL fetcher");
            this.fetcherThread.start();
            boolean ready = readySignal.await(30L, TimeUnit.SECONDS);
            if (!ready) {
                String errorMsg = "Waited for more than 30 seconds to fetch the CRL, killing the service";
                LOG.error((Object)errorMsg);
                throw new IllegalStateException(errorMsg);
            }
        }
        super.serviceStart();
    }

    @Override
    public void serviceStop() throws Exception {
        LOG.info((Object)"Stopping CRL fetching service");
        if (this.fetcherThread != null) {
            this.fetcherThread.interrupt();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public void setIntervalTimeUnit(TimeUnit intervalTimeUnit) {
        this.intervalTimeUnit = intervalTimeUnit;
    }

    @VisibleForTesting
    public long getFetcherInterval() {
        return this.fetcherInterval;
    }

    @VisibleForTesting
    public Thread getFetcherThread() {
        return this.fetcherThread;
    }

    private class FetcherThread
    extends Thread {
        private final CountDownLatch readySignal;
        private int numberOfFailures = 0;
        private boolean init = true;

        private FetcherThread(CountDownLatch readySignal) {
            this.readySignal = readySignal;
        }

        @Override
        public void run() {
            LOG.debug((Object)"Starting CRL fetcher thread");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!this.init) {
                        RevocationListFetcherService.this.intervalTimeUnit.sleep(RevocationListFetcherService.this.fetcherInterval);
                    } else {
                        this.init = false;
                    }
                    RevocationListFetcherService.this.crlFetcher.fetch();
                    this.numberOfFailures = 0;
                    this.readySignal.countDown();
                }
                catch (IOException ex) {
                    ++this.numberOfFailures;
                    if (this.numberOfFailures <= 5) continue;
                    LOG.error((Object)"Failed to fetch CRL more than 5 times. Stopping fetcher thread", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException ex) {
                    LOG.info((Object)"CRL fetcher thread is terminating...", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }
            LOG.info((Object)"CRL fetcher thread terminated");
        }
    }
}

