/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import java.lang.reflect.Constructor;
import org.apache.hadoop.io.erasurecode.ECBlock;
import org.apache.hadoop.io.erasurecode.ECBlockGroup;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.TestCoderBase;
import org.apache.hadoop.io.erasurecode.coder.ErasureCoder;
import org.apache.hadoop.io.erasurecode.coder.ErasureCodingStep;

public abstract class TestErasureCoderBase
extends TestCoderBase {
    protected Class<? extends ErasureCoder> encoderClass;
    protected Class<? extends ErasureCoder> decoderClass;
    private ErasureCoder encoder;
    private ErasureCoder decoder;
    protected int numChunksInBlock = 16;

    protected void testCoding(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders();
        this.performTestCoding(this.baseChunkSize, true);
        this.performTestCoding(this.baseChunkSize - 17, false);
        this.performTestCoding(this.baseChunkSize + 16, true);
    }

    private void performTestCoding(int chunkSize, boolean usingSlicedBuffer) {
        this.setChunkSize(chunkSize);
        this.prepareBufferAllocator(usingSlicedBuffer);
        ECBlockGroup blockGroup = this.prepareBlockGroupForEncoding();
        ECBlock[] clonedDataBlocks = this.cloneBlocksWithData((TestBlock[])blockGroup.getDataBlocks());
        TestBlock[] parityBlocks = (TestBlock[])blockGroup.getParityBlocks();
        ErasureCodingStep codingStep = this.encoder.calculateCoding(blockGroup);
        this.performCodingStep(codingStep);
        ECBlock[] backupBlocks = this.backupAndEraseBlocks((TestBlock[])clonedDataBlocks, parityBlocks);
        blockGroup = new ECBlockGroup(clonedDataBlocks, blockGroup.getParityBlocks());
        codingStep = this.decoder.calculateCoding(blockGroup);
        this.performCodingStep(codingStep);
        this.compareAndVerify(backupBlocks, codingStep.getOutputBlocks());
    }

    protected void performCodingStep(ErasureCodingStep codingStep) {
        ECBlock[] inputBlocks = codingStep.getInputBlocks();
        ECBlock[] outputBlocks = codingStep.getOutputBlocks();
        ECChunk[] inputChunks = new ECChunk[inputBlocks.length];
        ECChunk[] outputChunks = new ECChunk[outputBlocks.length];
        for (int i = 0; i < this.numChunksInBlock; ++i) {
            int j;
            for (j = 0; j < inputBlocks.length; ++j) {
                inputChunks[j] = ((TestBlock)inputBlocks[j]).chunks[i];
            }
            for (j = 0; j < outputBlocks.length; ++j) {
                outputChunks[j] = this.allocateOutputChunk();
                ((TestBlock)outputBlocks[j]).chunks[i] = outputChunks[j];
            }
            codingStep.performCoding(inputChunks, outputChunks);
        }
        codingStep.finish();
    }

    protected void compareAndVerify(ECBlock[] erasedBlocks, ECBlock[] recoveredBlocks) {
        for (int i = 0; i < erasedBlocks.length; ++i) {
            this.compareAndVerify(((TestBlock)erasedBlocks[i]).chunks, ((TestBlock)recoveredBlocks[i]).chunks);
        }
    }

    private void prepareCoders() {
        if (this.encoder == null) {
            this.encoder = this.createEncoder();
        }
        if (this.decoder == null) {
            this.decoder = this.createDecoder();
        }
    }

    protected ErasureCoder createEncoder() {
        ErasureCoder encoder;
        try {
            Constructor<? extends ErasureCoder> constructor = this.encoderClass.getConstructor(Integer.TYPE, Integer.TYPE);
            encoder = constructor.newInstance(this.numDataUnits, this.numParityUnits);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create encoder", e);
        }
        encoder.setConf(this.getConf());
        return encoder;
    }

    protected ErasureCoder createDecoder() {
        ErasureCoder decoder;
        try {
            Constructor<? extends ErasureCoder> constructor = this.decoderClass.getConstructor(Integer.TYPE, Integer.TYPE);
            decoder = constructor.newInstance(this.numDataUnits, this.numParityUnits);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create decoder", e);
        }
        decoder.setConf(this.getConf());
        return decoder;
    }

    protected ECBlockGroup prepareBlockGroupForEncoding() {
        int i;
        ECBlock[] dataBlocks = new TestBlock[this.numDataUnits];
        ECBlock[] parityBlocks = new TestBlock[this.numParityUnits];
        for (i = 0; i < this.numDataUnits; ++i) {
            dataBlocks[i] = this.generateDataBlock();
        }
        for (i = 0; i < this.numParityUnits; ++i) {
            parityBlocks[i] = this.allocateOutputBlock();
        }
        return new ECBlockGroup(dataBlocks, parityBlocks);
    }

    protected ECBlock generateDataBlock() {
        ECChunk[] chunks = new ECChunk[this.numChunksInBlock];
        for (int i = 0; i < this.numChunksInBlock; ++i) {
            chunks[i] = this.generateDataChunk();
        }
        return new TestBlock(chunks);
    }

    protected TestBlock[] backupAndEraseBlocks(TestBlock[] dataBlocks, TestBlock[] parityBlocks) {
        TestBlock block;
        int i;
        TestBlock[] toEraseBlocks = new TestBlock[this.erasedDataIndexes.length + this.erasedParityIndexes.length];
        int idx = 0;
        for (i = 0; i < this.erasedDataIndexes.length; ++i) {
            block = dataBlocks[this.erasedDataIndexes[i]];
            toEraseBlocks[idx++] = this.cloneBlockWithData(block);
            this.eraseDataFromBlock(block);
        }
        for (i = 0; i < this.erasedParityIndexes.length; ++i) {
            block = parityBlocks[this.erasedParityIndexes[i]];
            toEraseBlocks[idx++] = this.cloneBlockWithData(block);
            this.eraseDataFromBlock(block);
        }
        return toEraseBlocks;
    }

    protected TestBlock allocateOutputBlock() {
        ECChunk[] chunks = new ECChunk[this.numChunksInBlock];
        return new TestBlock(chunks);
    }

    protected TestBlock[] cloneBlocksWithData(TestBlock[] blocks) {
        TestBlock[] results = new TestBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            results[i] = this.cloneBlockWithData(blocks[i]);
        }
        return results;
    }

    protected TestBlock cloneBlockWithData(TestBlock block) {
        ECChunk[] newChunks = this.cloneChunksWithData(block.chunks);
        return new TestBlock(newChunks);
    }

    protected void eraseDataFromBlock(TestBlock theBlock) {
        this.eraseDataFromChunks(theBlock.chunks);
        theBlock.setErased(true);
    }

    protected static class TestBlock
    extends ECBlock {
        protected ECChunk[] chunks;

        public TestBlock(ECChunk[] chunks) {
            this.chunks = chunks;
        }
    }
}

