/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.CRLFetcher;
import org.apache.hadoop.security.ssl.CRLFetcherFactory;
import org.apache.hadoop.security.ssl.FailingCRLFetcher;
import org.apache.hadoop.security.ssl.LocalDummyCRLFetcher;
import org.apache.hadoop.security.ssl.RevocationListFetcherService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestRevocationListFetcher {
    private static final Logger LOG = LogManager.getLogger(TestRevocationListFetcher.class);
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestRevocationListFetcher.class.getSimpleName()).toString();
    private final File outputFile = Paths.get(BASE_DIR, "crl.pem").toFile();
    private final File baseDirFile = new File(BASE_DIR);
    private Configuration conf;
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        CRLFetcherFactory.getInstance().clearFetcherCache();
        this.baseDirFile.mkdirs();
    }

    @After
    public void tearDown() throws Exception {
        if (this.baseDirFile.exists()) {
            FileUtils.deleteDirectory((File)this.baseDirFile);
        }
        this.conf = null;
    }

    @Test
    @Ignore
    public void testRemoteCRLFetcher() throws Exception {
        Assert.assertFalse((boolean)this.outputFile.exists());
        this.conf.set("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.RemoteCRLFetcher");
        this.conf.set("hops.crl.input.uri", "http://bbc4.sics.se:34821/intermediate.crl.pem");
        this.conf.set("hops.crl.output.file", this.outputFile.getAbsolutePath());
        CRLFetcher fetcher = CRLFetcherFactory.getInstance().getCRLFetcher(this.conf);
        Assert.assertNotNull((Object)fetcher);
        fetcher.fetch();
        Assert.assertTrue((boolean)this.outputFile.exists());
        CRLFetcher fetcher1 = CRLFetcherFactory.getInstance().getCRLFetcher(this.conf);
        Assert.assertEquals((Object)fetcher, (Object)fetcher1);
    }

    @Test
    @Ignore
    public void testHTTPSRemoteCRLFetcher() throws Exception {
        Assert.assertFalse((boolean)this.outputFile.exists());
        this.conf.set("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.DevRemoteCRLFetcher");
        this.conf.set("hops.crl.input.uri", "https://bbc4.sics.se:38591/intermediate.crl.pem");
        this.conf.set("hops.crl.output.file", this.outputFile.getAbsolutePath());
        CRLFetcher fetcher = CRLFetcherFactory.getInstance().getCRLFetcher(this.conf);
        Assert.assertNotNull((Object)fetcher);
        fetcher.fetch();
        Assert.assertTrue((boolean)this.outputFile.exists());
    }

    @Test
    public void testDummyLocalCRLFetcher() throws Exception {
        String payload = "something_to_write";
        this.prepareForDummyCRLFetcher(payload);
        CRLFetcher fetcher = CRLFetcherFactory.getInstance().getCRLFetcher(this.conf);
        fetcher.fetch();
        Assert.assertTrue((boolean)this.outputFile.exists());
        String in = FileUtils.readFileToString((File)this.outputFile);
        Assert.assertEquals((Object)payload, (Object)in);
    }

    @Test(timeout=10000L)
    public void testRevocationListFetcherService() throws Exception {
        String payload = "something_to_write";
        this.prepareForDummyCRLFetcher(payload);
        RevocationListFetcherService crlFetcherService = new RevocationListFetcherService();
        crlFetcherService.setIntervalTimeUnit(TimeUnit.SECONDS);
        this.conf.set("hops.crl.fetcher.interval", "1s");
        crlFetcherService.serviceInit(this.conf);
        crlFetcherService.serviceStart();
        TimeUnit.SECONDS.sleep(crlFetcherService.getFetcherInterval());
        long lastModified = this.outputFile.lastModified();
        Assert.assertTrue((boolean)this.outputFile.exists());
        TimeUnit.SECONDS.sleep(crlFetcherService.getFetcherInterval() + 1L);
        Assert.assertTrue((boolean)this.outputFile.exists());
        Assert.assertTrue((this.outputFile.lastModified() > lastModified ? 1 : 0) != 0);
        crlFetcherService.serviceStop();
    }

    @Test(timeout=40000L)
    public void testFailedRevocationListFetcherService() throws Exception {
        this.conf.set("hops.crl.fetcher.class", "org.apache.hadoop.security.ssl.RemoteCRLFetcher");
        this.conf.set("hops.crl.input.uri", "http://i_hope_this_does_not_exist.sics.se:24376/intermediate.crl.pem");
        this.conf.set("hops.crl.output.file", this.outputFile.getAbsolutePath());
        this.conf.set("hops.crl.fetcher.interval", "1s");
        RevocationListFetcherService crlFetcherService = new RevocationListFetcherService();
        crlFetcherService.setIntervalTimeUnit(TimeUnit.SECONDS);
        crlFetcherService.serviceInit(this.conf);
        this.rule.expect(IllegalStateException.class);
        crlFetcherService.serviceStart();
    }

    @Test(timeout=12000L)
    public void testFailAfterAWhileFetcher() throws Exception {
        this.conf.set("hops.crl.fetcher.class", FailingCRLFetcher.class.getCanonicalName());
        this.conf.set("hops.crl.input.uri", "file://" + Paths.get(BASE_DIR, "something"));
        this.conf.set("hops.crl.output.file", "file://" + Paths.get(BASE_DIR, "something"));
        this.conf.set("hops.crl.fetcher.interval", "1s");
        RevocationListFetcherService crlFetcherService = new RevocationListFetcherService();
        crlFetcherService.setIntervalTimeUnit(TimeUnit.SECONDS);
        crlFetcherService.serviceInit(this.conf);
        crlFetcherService.serviceStart();
        Assert.assertTrue((boolean)crlFetcherService.getFetcherThread().isAlive());
        TimeUnit.SECONDS.sleep(crlFetcherService.getFetcherInterval() * 8L);
        Assert.assertFalse((boolean)crlFetcherService.getFetcherThread().isAlive());
        crlFetcherService.serviceStop();
    }

    private void prepareForDummyCRLFetcher(String payload) throws IOException {
        byte[] bytes = payload.getBytes();
        File inputFile = Paths.get(BASE_DIR, "intermediate.crl.pem").toFile();
        FileUtils.writeByteArrayToFile((File)inputFile, (byte[])bytes, (boolean)false);
        this.conf.set("hops.crl.fetcher.class", LocalDummyCRLFetcher.class.getCanonicalName());
        this.conf.set("hops.crl.input.uri", "file://" + inputFile.getAbsolutePath());
        this.conf.set("hops.crl.output.file", this.outputFile.getAbsolutePath());
    }
}

