/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.RpcTLSUtils;
import org.apache.hadoop.util.envVars.EnvironmentVariables;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTLSRPCServer {
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestTLSRPCServer.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private static final int KB = 1024;
    private final String keyAlgorithm = "RSA";
    private final String signatureAlgorithm = "SHA256withRSA";
    private final String password = "password";
    private static String classPathDir;
    private Configuration conf;
    private Server server;

    @BeforeClass
    public static void beforeClass() throws Exception {
        BASE_DIR_FILE.mkdirs();
        classPathDir = KeyStoreTestUtil.getClasspathDir(TestTLSRPCServer.class);
    }

    @Before
    public void beforeTest() {
        this.conf = new Configuration();
    }

    @After
    public void afterTest() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
    }

    @Test
    public void testLargeResponse() throws Exception {
        String clientName = "Alice";
        this.setupTLSMaterial(clientName);
        RPC.setProtocolEngine((Configuration)this.conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine.class);
        RpcTLSUtils.MockEnvironmentVariables envs = new RpcTLSUtils.MockEnvironmentVariables();
        envs.setEnv("MATERIAL_DIRECTORY", BASE_DIR);
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)envs);
        RPC.Builder serverBuilder = TestRpcBase.newServerBuilder(this.conf).setNumHandlers(1).setSecretManager(null).setnumReaders(2);
        this.server = TestRpcBase.setupTestServer(serverBuilder);
        char[] payload = new char[0x600000];
        String payloadString = new String(payload);
        UserGroupInformation clientUGI = UserGroupInformation.createRemoteUser((String)clientName);
        TestProtos.EchoResponseProto response = RpcTLSUtils.makeEchoRequest(clientUGI, this.server.getListenerAddress(), this.conf, payloadString);
        Assert.assertEquals((Object)payloadString, (Object)response.getMessage());
    }

    private RpcTLSUtils.TLSSetup setupTLSMaterial(String clientName) throws GeneralSecurityException, IOException {
        Path serverKeystore = Paths.get(BASE_DIR, "server.kstore.jks");
        Path serverTruststore = Paths.get(BASE_DIR, "server.tstore.jks");
        Path sslServerConfPath = Paths.get(classPathDir, TestTLSRPCServer.class.getSimpleName() + ".ssl-server.xml");
        Path clientKeystore = Paths.get(BASE_DIR, clientName + "__kstore.jks");
        Path clientTruststore = Paths.get(BASE_DIR, clientName + "__tstore.jks");
        Path clientPasswordLocation = Paths.get(BASE_DIR, clientName + "__cert.key");
        RpcTLSUtils.TLSSetup tlsSetup = new RpcTLSUtils.TLSSetup.Builder().setKeyAlgorithm("RSA").setSignatureAlgorithm("SHA256withRSA").setServerKstore(serverKeystore).setServerTstore(serverTruststore).setServerStorePassword("password").setClientKstore(clientKeystore).setClientTstore(clientTruststore).setClientStorePassword("password").setClientPasswordLocation(clientPasswordLocation).setClientUserName(clientName).setSslServerConf(sslServerConfPath).build();
        RpcTLSUtils.setupTLSMaterial(this.conf, tlsSetup, TestTLSRPCServer.class);
        this.conf.setBoolean("hops.crl.validation.enabled", false);
        return tlsSetup;
    }
}

