/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.util.HashMap;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestECSchema {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Test
    public void testGoodSchema() {
        int numDataUnits = 6;
        int numParityUnits = 3;
        String codec = "rs";
        String extraOption = "extraOption";
        String extraOptionValue = "extraOptionValue";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("numDataUnits", String.valueOf(numDataUnits));
        options.put("numParityUnits", String.valueOf(numParityUnits));
        options.put("codec", codec);
        options.put(extraOption, extraOptionValue);
        ECSchema schema = new ECSchema(options);
        System.out.println(schema.toString());
        Assert.assertEquals((long)numDataUnits, (long)schema.getNumDataUnits());
        Assert.assertEquals((long)numParityUnits, (long)schema.getNumParityUnits());
        Assert.assertEquals((Object)codec, (Object)schema.getCodecName());
        Assert.assertEquals((Object)extraOptionValue, schema.getExtraOptions().get(extraOption));
    }
}

