/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.RpcSSLEngine;
import org.apache.hadoop.ipc.Server;

public abstract class RpcSSLEngineAbstr
implements RpcSSLEngine {
    private static final Log LOG = LogFactory.getLog(RpcSSLEngineAbstr.class);
    protected final SocketChannel socketChannel;
    protected final SSLEngine sslEngine;
    protected static final int KB = 1024;
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    protected ByteBuffer serverAppBuffer;
    protected ByteBuffer clientAppBuffer;
    protected ByteBuffer serverNetBuffer;
    protected ByteBuffer clientNetBuffer;

    public RpcSSLEngineAbstr(SocketChannel socketChannel, SSLEngine sslEngine) {
        this.socketChannel = socketChannel;
        this.sslEngine = sslEngine;
        this.serverAppBuffer = ByteBuffer.allocate(102400);
        this.clientAppBuffer = ByteBuffer.allocate(102400);
        this.serverNetBuffer = ByteBuffer.allocate(102400);
        this.clientNetBuffer = ByteBuffer.allocate(102400);
    }

    @Override
    public boolean doHandshake() throws IOException {
        LOG.debug((Object)"Starting TLS handshake with peer");
        ByteBuffer serverAppBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        ByteBuffer clientAppBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.serverNetBuffer.clear();
        this.clientNetBuffer.clear();
        SSLEngineResult.HandshakeStatus handshakeStatus = this.sslEngine.getHandshakeStatus();
        block27: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (handshakeStatus) {
                case NEED_UNWRAP: {
                    SSLEngineResult result;
                    if (this.socketChannel.read(this.clientNetBuffer) < 0) {
                        if (this.sslEngine.isInboundDone() && this.sslEngine.isOutboundDone()) {
                            return false;
                        }
                        try {
                            this.sslEngine.closeInbound();
                        }
                        catch (SSLException sSLException) {
                            // empty catch block
                        }
                        this.sslEngine.closeOutbound();
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block27;
                    }
                    this.clientNetBuffer.flip();
                    try {
                        result = this.sslEngine.unwrap(this.clientNetBuffer, clientAppBuffer);
                        this.clientNetBuffer.compact();
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        this.sslEngine.closeOutbound();
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            clientAppBuffer = this.enlargeApplicationBuffer(clientAppBuffer);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.clientNetBuffer = this.handleBufferUnderflow(this.clientNetBuffer);
                            continue block27;
                        }
                        case CLOSED: {
                            if (this.sslEngine.isOutboundDone()) {
                                return false;
                            }
                            this.sslEngine.closeOutbound();
                            handshakeStatus = this.sslEngine.getHandshakeStatus();
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_WRAP: {
                    SSLEngineResult result;
                    this.serverNetBuffer.clear();
                    try {
                        result = this.sslEngine.wrap(serverAppBuffer, this.serverNetBuffer);
                        handshakeStatus = result.getHandshakeStatus();
                    }
                    catch (SSLException ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        this.sslEngine.closeOutbound();
                        handshakeStatus = this.sslEngine.getHandshakeStatus();
                        continue block27;
                    }
                    switch (result.getStatus()) {
                        case OK: {
                            this.serverNetBuffer.flip();
                            while (this.serverNetBuffer.hasRemaining()) {
                                this.socketChannel.write(this.serverNetBuffer);
                            }
                            continue block27;
                        }
                        case BUFFER_OVERFLOW: {
                            this.serverNetBuffer = this.enlargePacketBuffer(this.serverNetBuffer);
                            continue block27;
                        }
                        case BUFFER_UNDERFLOW: {
                            throw new SSLException("Buffer overflow occurred after a wrap.");
                        }
                        case CLOSED: {
                            try {
                                this.serverNetBuffer.flip();
                                while (this.serverNetBuffer.hasRemaining()) {
                                    this.socketChannel.write(this.serverNetBuffer);
                                }
                                this.clientNetBuffer.clear();
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex, (Throwable)ex);
                                handshakeStatus = this.sslEngine.getHandshakeStatus();
                            }
                            continue block27;
                        }
                    }
                    throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        this.exec.execute(task);
                    }
                    handshakeStatus = this.sslEngine.getHandshakeStatus();
                    continue block27;
                }
                case FINISHED: {
                    continue block27;
                }
                case NOT_HANDSHAKING: {
                    continue block27;
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.sslEngine.closeOutbound();
        this.doHandshake();
        if (this.exec != null) {
            this.exec.shutdown();
        }
    }

    @Override
    public abstract int write(WritableByteChannel var1, ByteBuffer var2) throws IOException;

    @Override
    public abstract int read(ReadableByteChannel var1, ByteBuffer var2, Server.Connection var3) throws IOException;

    protected ByteBuffer enlargeApplicationBuffer(ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, this.sslEngine.getSession().getApplicationBufferSize());
    }

    protected ByteBuffer enlargePacketBuffer(ByteBuffer buffer) {
        return this.enlargeBuffer(buffer, this.sslEngine.getSession().getPacketBufferSize());
    }

    protected ByteBuffer handleBufferUnderflow(ByteBuffer buffer) {
        if (this.sslEngine.getSession().getPacketBufferSize() < buffer.limit()) {
            return buffer;
        }
        ByteBuffer newBuffer = this.enlargePacketBuffer(buffer);
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }

    private ByteBuffer enlargeBuffer(ByteBuffer buffer, int sessionProposedCapacity) {
        if (sessionProposedCapacity > buffer.capacity()) {
            return ByteBuffer.allocate(sessionProposedCapacity);
        }
        return ByteBuffer.allocate(buffer.capacity() * 2);
    }
}

