/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.SSLCertificateException;
import org.apache.hadoop.net.hopssslchecks.EnvVariableHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.net.hopssslchecks.LocalResourceHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.NormalUserCertLocServiceHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.NormalUserMaterilizeDirSSLCheck;
import org.apache.hadoop.net.hopssslchecks.SuperUserHopsSSLCheck;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.CertificateLocalization;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.ReloadingX509KeyManager;
import org.apache.hadoop.security.ssl.ReloadingX509TrustManager;
import org.apache.hadoop.security.ssl.SSLFactory;

public class HopsSSLSocketFactory
extends SocketFactory
implements Configurable {
    public static final String FORCE_CONFIGURE = "client.rpc.ssl.force.configure";
    public static final boolean DEFAULT_FORCE_CONFIGURE = false;
    private static final String KEY_STORE_FILEPATH_DEFAULT = "client.keystore.jks";
    private static final String KEY_STORE_PASSWORD_DEFAULT = "";
    private static final String KEY_PASSWORD_DEFAULT = "";
    private static final String TRUST_STORE_FILEPATH_DEFAULT = "client.truststore.jks";
    private static final String TRUST_STORE_PASSWORD_DEFAULT = "";
    private static final String SOCKET_ENABLED_PROTOCOL_DEFAULT = "TLSv1.2";
    public static final String LOCALIZED_PASSWD_FILE_NAME = "material_passwd";
    public static final String LOCALIZED_KEYSTORE_FILE_NAME = "k_certificate";
    public static final String LOCALIZED_TRUSTSTORE_FILE_NAME = "t_certificate";
    public static final String PASSWD_FILE_SUFFIX = "__cert.key";
    public static final String KEYSTORE_SUFFIX = "__kstore.jks";
    public static final String TRUSTSTORE_SUFFIX = "__tstore.jks";
    public static final String CRYPTO_MATERIAL_ENV_VAR = "MATERIAL_DIRECTORY";
    private static final String PASSPHRASE = "adminpw";
    private static final String SOCKET_FACTORY_NAME = HopsSSLSocketFactory.class.getCanonicalName();
    private static final String SERVICE_CERTS_DIR_DEFAULT = "/srv/hops/kagent-certs/keystores";
    private static final String CLIENT_MATERIALIZE_DIR_DEFAULT = "/srv/hops/domains/domain1/kafkacerts";
    public static final String USERNAME_PATTERN = "\\w*__\\w*";
    private static final Log LOG = LogFactory.getLog(HopsSSLSocketFactory.class);
    private static final HopsSSLCheck ENV_VARIABLE_CHECK = new EnvVariableHopsSSLCheck();
    private static final HopsSSLCheck LOCAL_RESOURCE = new LocalResourceHopsSSLCheck();
    private static final HopsSSLCheck NORMAL_USER_MATERIALIZE_DIR = new NormalUserMaterilizeDirSSLCheck();
    private static final HopsSSLCheck NORMAL_USER_CERTIFICATE_LOCALIZATION = new NormalUserCertLocServiceHopsSSLCheck();
    private static final HopsSSLCheck SUPER_USER = new SuperUserHopsSSLCheck();
    private static final Set<HopsSSLCheck> HOPS_SSL_CHECKS = new TreeSet<HopsSSLCheck>();
    private HopsSSLCryptoMaterial configuredCryptoMaterial = null;
    private ReloadingX509KeyManager reloadingKeyManager = null;
    private ReloadingX509TrustManager reloadingTrustManager = null;
    private static Map<CryptoKeys, String> DEPRECATED_CRYPTO_KEYS;
    private Configuration conf;
    private Configuration sslClientConf;
    private String keyStoreFilePath;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.sslClientConf = new Configuration(false);
        String sslConfResource = conf.get("hadoop.ssl.client.conf", "ssl-client.xml");
        this.sslClientConf.addResource(sslConfResource);
    }

    public void configureCryptoMaterial(CertificateLocalization certificateLocalization, Set<String> proxySuperusers) throws SSLCertificateException {
        UserGroupInformation currentUser = null;
        try {
            currentUser = UserGroupInformation.getCurrentUser();
            for (HopsSSLCheck checks : HOPS_SSL_CHECKS) {
                this.configuredCryptoMaterial = checks.check(currentUser, proxySuperusers, this.conf, certificateLocalization);
                if (this.configuredCryptoMaterial == null) continue;
                break;
            }
            if (this.configuredCryptoMaterial == null) {
                String message = "> HopsSSLSocketFactory could not determine cryptographic material for user <" + currentUser.getUserName() + ">. Check your configuration!";
                SSLCertificateException ex = new SSLCertificateException(message);
                LOG.error((Object)message, (Throwable)ex);
                throw ex;
            }
            HopsSSLSocketFactory.setTlsConfiguration(this.configuredCryptoMaterial.getKeyStoreLocation(), this.configuredCryptoMaterial.getKeyStorePassword(), this.configuredCryptoMaterial.getKeyPassword(), this.configuredCryptoMaterial.getTrustStoreLocation(), this.configuredCryptoMaterial.getTrustStorePassword(), this.conf);
            this.keyStoreFilePath = this.conf.get(CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), KEY_STORE_FILEPATH_DEFAULT);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finally, the keystore that is used is: " + this.keyStoreFilePath));
            }
            this.conf.setBoolean(FORCE_CONFIGURE, false);
        }
        catch (IOException ex) {
            String user = currentUser != null ? currentUser.getUserName() : "Could not find user from UGI";
            LOG.error((Object)("Error while configuring SocketFactory for user <" + user + "> " + ex.getMessage()), (Throwable)ex);
            throw new SSLCertificateException(ex);
        }
    }

    public static void configureTlsClient(String filePrefix, String username, Configuration conf) {
        String pref = Paths.get(filePrefix, username).toString();
        HopsSSLSocketFactory.setTlsConfiguration(pref + KEYSTORE_SUFFIX, pref + TRUSTSTORE_SUFFIX, conf);
    }

    public static void configureTlsClient(String kstorePath, String kstorePass, String keyPass, String tstorePath, String tstorePass, Configuration conf) {
        conf.set(CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), kstorePath);
        conf.set(CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), kstorePass);
        conf.set(CryptoKeys.KEY_PASSWORD_KEY.getValue(), keyPass);
        conf.set(CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), tstorePath);
        conf.set(CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), tstorePass);
        conf.set("hadoop.rpc.socket.factory.class.default", SOCKET_FACTORY_NAME);
    }

    private static void setTlsConfiguration(String kstorePath, String tstorePath, Configuration conf) {
        HopsSSLSocketFactory.setTlsConfiguration(kstorePath, PASSPHRASE, PASSPHRASE, tstorePath, PASSPHRASE, conf);
    }

    public static void setTlsConfiguration(String kstorePath, String kstorePass, String tstorePath, String tstorePass, Configuration conf) {
        HopsSSLSocketFactory.setTlsConfiguration(kstorePath, kstorePass, kstorePass, tstorePath, tstorePass, conf);
    }

    public static void setTlsConfiguration(String kstorePath, String kstorePass, String keyPassword, String tstorePath, String tstorePass, Configuration conf) {
        conf.set(CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), kstorePath);
        conf.set(CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), kstorePass);
        conf.set(CryptoKeys.KEY_PASSWORD_KEY.getValue(), keyPassword);
        conf.set(CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), tstorePath);
        conf.set(CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), tstorePass);
        conf.set("hadoop.rpc.socket.factory.class.default", SOCKET_FACTORY_NAME);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public void stopReloadingKeyManagers() {
        if (this.reloadingKeyManager != null) {
            this.reloadingKeyManager.stop();
        }
        if (this.reloadingTrustManager != null) {
            this.reloadingTrustManager.destroy();
        }
    }

    @Override
    public Socket createSocket() throws IOException, UnknownHostException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating SSL client socket");
        }
        if (this.conf.getBoolean(FORCE_CONFIGURE, false)) {
            this.setConf(this.conf);
        }
        SSLContext sslCtx = this.initializeSSLContext();
        SSLSocketFactory socketFactory = sslCtx.getSocketFactory();
        return socketFactory.createSocket();
    }

    private SSLContext initializeSSLContext() throws IOException {
        try {
            String enabledProtocol = this.conf.get(CryptoKeys.SOCKET_ENABLED_PROTOCOL.getValue(), CryptoKeys.SOCKET_ENABLED_PROTOCOL.getDefaultValue());
            SSLContext sslCtx = SSLContext.getInstance(enabledProtocol);
            long keyStoreReloadInterval = 10000L;
            String timeUnitStr = "MILLISECONDS";
            long trustStoreReloadInterval = 10000L;
            if (this.sslClientConf != null) {
                keyStoreReloadInterval = this.sslClientConf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.CLIENT, "ssl.{0}.keystore.reload.interval"), 10000L);
                timeUnitStr = this.sslClientConf.get(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.CLIENT, "ssl.{0}.keystore.reload.timeunit"), "MILLISECONDS");
                trustStoreReloadInterval = this.sslClientConf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.CLIENT, "ssl.{0}.truststore.reload.interval"), 10000L);
            }
            TimeUnit timeUnit = TimeUnit.valueOf(timeUnitStr);
            sslCtx.init(this.createKeyManagers(keyStoreReloadInterval, timeUnit), this.createTrustManagers(trustStoreReloadInterval), null);
            return sslCtx;
        }
        catch (GeneralSecurityException ex) {
            String keyStore = this.conf.get(CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue());
            LOG.error((Object)("Could not initialize SSLContext with keystore " + keyStore), (Throwable)ex);
            throw new IOException("Error initializing SSLContext", ex);
        }
    }

    private KeyManager[] createKeyManagers(long reloadInterval, TimeUnit timeUnit) throws GeneralSecurityException, IOException {
        this.reloadingKeyManager = new ReloadingX509KeyManager("JKS", this.configuredCryptoMaterial.getKeyStoreLocation(), this.configuredCryptoMaterial.getKeyStorePassword(), this.configuredCryptoMaterial.getPasswordFileLocation(), this.configuredCryptoMaterial.getKeyStorePassword(), reloadInterval, timeUnit);
        if (this.configuredCryptoMaterial.needsReloading()) {
            this.reloadingKeyManager.init();
        }
        return new KeyManager[]{this.reloadingKeyManager};
    }

    private TrustManager[] createTrustManagers(long reloadInterval) throws GeneralSecurityException, IOException {
        this.reloadingTrustManager = new ReloadingX509TrustManager("JKS", this.configuredCryptoMaterial.getTrustStoreLocation(), this.configuredCryptoMaterial.getTrustStorePassword(), this.configuredCryptoMaterial.getPasswordFileLocation(), reloadInterval);
        if (this.configuredCryptoMaterial.needsReloading()) {
            this.reloadingTrustManager.init();
        }
        return new TrustManager[]{this.reloadingTrustManager};
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localAddress, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(new InetSocketAddress(inetAddress, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.createSocket();
        socket.bind(new InetSocketAddress(localAddress, localPort));
        socket.connect(new InetSocketAddress(inetAddress, port));
        return socket;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HopsSSLSocketFactory) {
            return this == obj || ((HopsSSLSocketFactory)obj).getKeyStoreFilePath().equals(this.getKeyStoreFilePath());
        }
        return false;
    }

    public int hashCode() {
        int result = 3;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + this.keyStoreFilePath.hashCode();
        return result;
    }

    static {
        HOPS_SSL_CHECKS.add(ENV_VARIABLE_CHECK);
        HOPS_SSL_CHECKS.add(NORMAL_USER_CERTIFICATE_LOCALIZATION);
        HOPS_SSL_CHECKS.add(LOCAL_RESOURCE);
        HOPS_SSL_CHECKS.add(NORMAL_USER_MATERIALIZE_DIR);
        HOPS_SSL_CHECKS.add(SUPER_USER);
        DEPRECATED_CRYPTO_KEYS = new HashMap<CryptoKeys, String>();
        DEPRECATED_CRYPTO_KEYS.put(CryptoKeys.SERVICE_CERTS_DIR, "Key <" + CryptoKeys.SERVICE_CERTS_DIR.getValue() + "> is deprecated and it will be removed in the future. Remove it from your configuration");
    }

    public static enum CryptoKeys {
        KEY_STORE_FILEPATH_KEY("client.rpc.ssl.keystore.filepath", "client.keystore.jks", PropType.FILEPATH),
        KEY_STORE_PASSWORD_KEY("client.rpc.ssl.keystore.password", "", PropType.LITERAL),
        KEY_PASSWORD_KEY("client.rpc.ssl.keypassword", "", PropType.LITERAL),
        TRUST_STORE_FILEPATH_KEY("client.rpc.ssl.truststore.filepath", "client.truststore.jks", PropType.FILEPATH),
        TRUST_STORE_PASSWORD_KEY("client.rpc.ssl.truststore.password", "", PropType.LITERAL),
        SOCKET_ENABLED_PROTOCOL("client.rpc.ssl.enabled.protocol", "TLSv1.2", PropType.LITERAL),
        SERVICE_CERTS_DIR("hops.service.certificates.directory", "/srv/hops/kagent-certs/keystores", PropType.LITERAL),
        CLIENT_MATERIALIZE_DIR("client.materialize.directory", "/srv/hops/domains/domain1/kafkacerts", PropType.LITERAL);

        private final String value;
        private final String defaultValue;
        private final PropType type;

        private CryptoKeys(String value, String defaultValue, PropType type) {
            this.value = value;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public String getValue() {
            this.handleDeprecation();
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public PropType getType() {
            return this.type;
        }

        private void handleDeprecation() {
            String msg = null;
            msg = (String)DEPRECATED_CRYPTO_KEYS.get((Object)this);
            if (msg != null) {
                LOG.warn((Object)msg);
            }
        }
    }

    public static enum PropType {
        FILEPATH,
        LITERAL;

    }
}

