/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.HopsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.CertificateLocalization;
import org.apache.hadoop.security.ssl.CryptoMaterial;

public class NormalUserMaterilizeDirSSLCheck
extends AbstractHopsSSLCheck {
    private static final Log LOG = LogFactory.getLog(NormalUserMaterilizeDirSSLCheck.class);

    public NormalUserMaterilizeDirSSLCheck() {
        super(95);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperUsers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        String hopsworksMaterializeDir;
        File fd;
        String username = ugi.getUserName();
        if ((username.matches("\\w*__\\w*") || !proxySuperUsers.contains(username)) && (fd = Paths.get(hopsworksMaterializeDir = configuration.get(HopsSSLSocketFactory.CryptoKeys.CLIENT_MATERIALIZE_DIR.getValue(), HopsSSLSocketFactory.CryptoKeys.CLIENT_MATERIALIZE_DIR.getDefaultValue()), username + "__kstore.jks").toFile()).exists()) {
            String passwordFileLocation;
            String password;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Crypto material found in " + hopsworksMaterializeDir));
            }
            if (certificateLocalization != null) {
                try {
                    CryptoMaterial material = certificateLocalization.getMaterialLocation(username);
                    password = material.getKeyStorePass();
                    passwordFileLocation = material.getPasswdLocation().toString();
                }
                catch (InterruptedException ex) {
                    throw new IOException(ex);
                }
            } else {
                File passwdFile = Paths.get(hopsworksMaterializeDir, username + "__cert.key").toFile();
                password = HopsUtil.readCryptoMaterialPassword(passwdFile);
                passwordFileLocation = passwdFile.toString();
            }
            return new HopsSSLCryptoMaterial(Paths.get(hopsworksMaterializeDir, username + "__kstore.jks").toString(), password, password, Paths.get(hopsworksMaterializeDir, username + "__tstore.jks").toString(), password, passwordFileLocation, true);
        }
        return null;
    }
}

