/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.CertificateLocalization;

public class CertificateLocalizationCtx {
    private static volatile CertificateLocalizationCtx instance = null;
    private CertificateLocalization certificateLocalization = null;
    private Set<String> proxySuperusers = null;

    private CertificateLocalizationCtx() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CertificateLocalizationCtx getInstance() {
        if (instance != null) return instance;
        Class<CertificateLocalizationCtx> clazz = CertificateLocalizationCtx.class;
        synchronized (CertificateLocalizationCtx.class) {
            if (instance != null) return instance;
            instance = new CertificateLocalizationCtx();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void setCertificateLocalization(CertificateLocalization certificateLocalization) {
        this.certificateLocalization = certificateLocalization;
    }

    public CertificateLocalization getCertificateLocalization() {
        return this.certificateLocalization;
    }

    public synchronized void setProxySuperusers(Configuration conf) {
        if (this.proxySuperusers == null) {
            this.proxySuperusers = this.getSuperusersFromConf(conf);
        }
    }

    public Set<String> getProxySuperusers() {
        return this.proxySuperusers;
    }

    private Set<String> getSuperusersFromConf(Configuration conf) {
        HashSet<String> superusers = new HashSet<String>();
        for (Map.Entry<String, String> entry : conf) {
            String propName = entry.getKey();
            if (!propName.startsWith("hadoop.proxyuser")) continue;
            String[] tokens = propName.split("\\.");
            superusers.add(tokens[2]);
        }
        return superusers;
    }
}

