/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;

public class CryptoMaterial {
    private final Path certFolder;
    private final Path keyStoreLocation;
    private int keyStoreSize;
    private final Path trustStoreLocation;
    private final Path passwdLocation;
    private final int trustStoreSize;
    private ByteBuffer keyStoreMem;
    private String keyStorePass;
    private ByteBuffer trustStoreMem;
    private String trustStorePass;
    private final AtomicBoolean tombstone;
    private STATE state;
    private int requestedApplications;

    public CryptoMaterial(Path certFolder, Path keyStoreLocation, Path trustStoreLocation, Path passwdLocation, ByteBuffer kStore, String kStorePass, ByteBuffer tstore, String tstorePass) {
        this.certFolder = certFolder;
        this.keyStoreLocation = keyStoreLocation;
        this.keyStoreSize = kStore.capacity();
        this.trustStoreLocation = trustStoreLocation;
        this.trustStoreSize = tstore.capacity();
        this.passwdLocation = passwdLocation;
        this.keyStoreMem = kStore;
        this.keyStorePass = kStorePass;
        this.trustStoreMem = tstore;
        this.trustStorePass = tstorePass;
        this.requestedApplications = 1;
        this.state = STATE.NEW;
        this.tombstone = new AtomicBoolean(false);
    }

    public Path getCertFolder() {
        return this.certFolder;
    }

    public Path getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public synchronized int getKeyStoreSize() {
        return this.keyStoreSize;
    }

    public Path getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public Path getPasswdLocation() {
        return this.passwdLocation;
    }

    public int getTrustStoreSize() {
        return this.trustStoreSize;
    }

    public synchronized ByteBuffer getKeyStoreMem() {
        return this.keyStoreMem.asReadOnlyBuffer();
    }

    public synchronized void updateKeyStoreMem(ByteBuffer keyStoreMem) {
        this.keyStoreMem = keyStoreMem;
    }

    public synchronized String getKeyStorePass() {
        return this.keyStorePass;
    }

    public synchronized void updateKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public synchronized ByteBuffer getTrustStoreMem() {
        return this.trustStoreMem.asReadOnlyBuffer();
    }

    public synchronized void updateTrustStoreMem(ByteBuffer trustStoreMem) {
        this.trustStoreMem = trustStoreMem;
    }

    public synchronized String getTrustStorePass() {
        return this.trustStorePass;
    }

    public synchronized void updateTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    public int getRequestedApplications() {
        return this.requestedApplications;
    }

    public void incrementRequestedApplications() {
        ++this.requestedApplications;
    }

    public void decrementRequestedApplications() {
        --this.requestedApplications;
    }

    public boolean isSafeToRemove() {
        return this.requestedApplications == 0;
    }

    public synchronized void changeState(STATE state) {
        this.state = state;
    }

    public synchronized STATE getState() {
        return this.state;
    }

    public boolean hasBeenCanceled() {
        return this.tombstone.get();
    }

    public synchronized boolean tryToCancel() {
        if (this.state.equals((Object)STATE.NEW)) {
            this.tombstone.set(true);
            return true;
        }
        return false;
    }

    public static enum STATE {
        NEW,
        ONGOING,
        FINISHED;

    }
}

