/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.ssl.KeyManagersReloaderThreadPool;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ReloadingX509TrustManager
implements X509TrustManager,
Runnable {
    @VisibleForTesting
    static final Log LOG = LogFactory.getLog(ReloadingX509TrustManager.class);
    @VisibleForTesting
    static final String RELOAD_ERROR_MESSAGE = "Could not load truststore (keep using existing one) : ";
    private String type;
    private File file;
    private String password;
    private final File passwordFileLocation;
    private long lastLoaded;
    private long reloadInterval;
    private AtomicReference<X509TrustManager> trustManagerRef;
    private WeakReference<ScheduledFuture> reloader = null;
    private final BackOff backOff;
    private long backOffTimeout = 0L;
    private int numberOfFailures = 0;
    private static final X509Certificate[] EMPTY = new X509Certificate[0];

    public ReloadingX509TrustManager(String type, String location, String password, long reloadInterval) throws IOException, GeneralSecurityException {
        this(type, location, password, null, reloadInterval);
    }

    public ReloadingX509TrustManager(String type, String location, String password, String passwordFileLocation, long reloadInterval) throws IOException, GeneralSecurityException {
        this.type = type;
        this.file = new File(location);
        this.password = password;
        this.passwordFileLocation = passwordFileLocation != null ? new File(passwordFileLocation) : null;
        this.trustManagerRef = new AtomicReference();
        this.trustManagerRef.set(this.loadTrustManager());
        this.reloadInterval = reloadInterval;
        this.backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(50L).setMaximumIntervalMillis(2000L).setMaximumRetries(3).build();
    }

    public void init() {
        if (this.reloader == null) {
            ScheduledFuture task = KeyManagersReloaderThreadPool.getInstance().scheduleTask(this, this.reloadInterval, TimeUnit.MILLISECONDS);
            this.reloader = new WeakReference<ScheduledFuture>(task);
        }
    }

    public void destroy() {
        ScheduledFuture task;
        if (this.reloader != null && (task = (ScheduledFuture)this.reloader.get()) != null) {
            task.cancel(true);
            this.reloader = null;
        }
    }

    public long getReloadInterval() {
        return this.reloadInterval;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown client chain certificate: " + chain[0].toString());
        }
        tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm == null) {
            throw new CertificateException("Unknown server chain certificate: " + chain[0].toString());
        }
        tm.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] issuers = EMPTY;
        X509TrustManager tm = this.trustManagerRef.get();
        if (tm != null) {
            issuers = tm.getAcceptedIssuers();
        }
        return issuers;
    }

    boolean needsReload() {
        boolean reload = true;
        if (this.file.exists()) {
            if (this.file.lastModified() == this.lastLoaded) {
                reload = false;
            }
        } else {
            this.lastLoaded = 0L;
        }
        return reload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509TrustManager loadTrustManager() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        X509TrustManager trustManager = null;
        KeyStore ks = KeyStore.getInstance(this.type);
        String tstorePassword = this.passwordFileLocation != null ? FileUtils.readFileToString((File)this.passwordFileLocation) : this.password;
        try (FileInputStream in = new FileInputStream(this.file);){
            ks.load(in, tstorePassword.toCharArray());
            this.lastLoaded = this.file.lastModified();
            LOG.debug((Object)("Loaded truststore '" + this.file + "'"));
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(SSLFactory.SSLCERTIFICATE);
        trustManagerFactory.init(ks);
        for (TrustManager trustManager1 : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager1 instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)trustManager1;
            break;
        }
        return trustManager;
    }

    private boolean hasFailed() {
        return this.backOffTimeout > 0L;
    }

    @Override
    public void run() {
        if (this.needsReload()) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.backOffTimeout);
                this.trustManagerRef.set(this.loadTrustManager());
                if (this.hasFailed()) {
                    this.backOff.reset();
                    this.numberOfFailures = 0;
                }
            }
            catch (Exception ex) {
                this.backOffTimeout = this.backOff.getBackOffInMillis();
                ++this.numberOfFailures;
                if (this.backOffTimeout != -1L) {
                    LOG.warn((Object)(RELOAD_ERROR_MESSAGE + ex.toString() + " trying again in " + this.backOffTimeout + " ms"));
                }
                LOG.error((Object)"Could not load truststore (keep using existing one) : , stop retrying", (Throwable)ex);
                this.destroy();
            }
        }
    }
}

