/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TrashPolicy;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Trash
extends Configured {
    private static final Log LOG = LogFactory.getLog(Trash.class);
    private TrashPolicy trashPolicy;

    public Trash(Configuration conf) throws IOException {
        this(FileSystem.get(conf), conf);
    }

    public Trash(FileSystem fs, Configuration conf) throws IOException {
        super(conf);
        this.trashPolicy = TrashPolicy.getInstance(conf, fs, fs.getHomeDirectory());
    }

    public static boolean moveToAppropriateTrash(FileSystem fs, Path p, Configuration conf) throws IOException {
        Path fullyResolvedPath = fs.resolvePath(p);
        FileSystem fullyResolvedFs = FileSystem.get(fullyResolvedPath.toUri(), conf);
        try {
            long trashInterval = fullyResolvedFs.getServerDefaults(fullyResolvedPath).getTrashInterval();
            if (0L != trashInterval) {
                Configuration confCopy = new Configuration(conf);
                confCopy.setLong("fs.trash.interval", trashInterval);
                conf = confCopy;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to get server trash configuration", (Throwable)e);
            throw new IOException("Failed to get server trash configuration", e);
        }
        Trash trash = new Trash(fullyResolvedFs, conf);
        return trash.moveToTrash(fullyResolvedPath);
    }

    public boolean isEnabled() {
        return this.trashPolicy.isEnabled();
    }

    public boolean moveToTrash(Path path) throws IOException {
        return this.trashPolicy.moveToTrash(path);
    }

    public void checkpoint() throws IOException {
        this.trashPolicy.createCheckpoint();
    }

    public void expunge() throws IOException {
        this.trashPolicy.deleteCheckpoint();
    }

    Path getCurrentTrashDir() throws IOException {
        return this.trashPolicy.getCurrentTrashDir();
    }

    TrashPolicy getTrashPolicy() {
        return this.trashPolicy;
    }

    public Runnable getEmptier() throws IOException {
        return this.trashPolicy.getEmptier();
    }

    public Path getCurrentTrashDir(Path path) throws IOException {
        return this.trashPolicy.getCurrentTrashDir(path);
    }
}

