/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.coder;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.io.erasurecode.coder.ErasureCoder;

@InterfaceAudience.Private
public abstract class AbstractErasureCoder
extends Configured
implements ErasureCoder {
    private final int numDataUnits;
    private final int numParityUnits;

    public AbstractErasureCoder(int numDataUnits, int numParityUnits) {
        this.numDataUnits = numDataUnits;
        this.numParityUnits = numParityUnits;
    }

    public AbstractErasureCoder(ECSchema schema) {
        this(schema.getNumDataUnits(), schema.getNumParityUnits());
    }

    @Override
    public int getNumDataUnits() {
        return this.numDataUnits;
    }

    @Override
    public int getNumParityUnits() {
        return this.numParityUnits;
    }

    @Override
    public boolean preferDirectBuffer() {
        return false;
    }

    @Override
    public void release() {
    }
}

