/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.HopsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.CertificateLocalization;

public class LocalResourceHopsSSLCheck
extends AbstractHopsSSLCheck {
    private static final Log LOG = LogFactory.getLog(LocalResourceHopsSSLCheck.class);

    public LocalResourceHopsSSLCheck() {
        super(100);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperusers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        File localizedKeystore = new File("k_certificate");
        if (localizedKeystore.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Crypto material found in container localized directory");
            }
            File passwordFile = new File("material_passwd");
            String password = HopsUtil.readCryptoMaterialPassword(passwordFile);
            return new HopsSSLCryptoMaterial("k_certificate", password, password, "t_certificate", password, "material_passwd", true);
        }
        return null;
    }
}

