/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;

public class HopsUtil {
    private static final Log LOG = LogFactory.getLog(HopsUtil.class);
    private static final TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    private static final Pattern CN_PATTERN = Pattern.compile(".*CN=([^,]+).*");
    private static final Pattern O_PATTERN = Pattern.compile(".*O=([^,]+).*");
    private static final Pattern OU_PATTERN = Pattern.compile(".*OU=([^,]+).*");

    public static String readCryptoMaterialPassword(File passwdFile) throws IOException {
        if (!passwdFile.exists()) {
            throw new FileNotFoundException("File containing crypto material password could not be found");
        }
        return FileUtils.readFileToString((File)passwdFile).trim();
    }

    public static String extractCNFromSubject(String subject) {
        Matcher matcher = CN_PATTERN.matcher(subject);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractOFromSubject(String subject) {
        Matcher matcher = O_PATTERN.matcher(subject);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractOUFromSubject(String subject) {
        Matcher matcher = OU_PATTERN.matcher(subject);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static void trustAllHTTPS() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustAll, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Could not initialize SSLContext for CRL fetcher", ex);
        }
    }

    public static void generateContainerSSLServerConfiguration(Configuration conf) throws IOException {
        HopsUtil.generateContainerSSLServerConfiguration(new File("material_passwd"), conf);
    }

    @VisibleForTesting
    public static void generateContainerSSLServerConfiguration(File passwdFile, Configuration conf) throws IOException {
        if (!passwdFile.exists()) {
            String cwd = System.getProperty("user.dir");
            throw new FileNotFoundException("File material_passwd does not exist in " + cwd);
        }
        String cryptoMaterialPassword = FileUtils.readFileToString((File)passwdFile);
        Configuration sslConf = HopsUtil.generateSSLServerConf(conf, cryptoMaterialPassword);
        HopsUtil.writeSSLConf(sslConf, conf, passwdFile);
    }

    private static Configuration generateSSLServerConf(Configuration conf, String cryptoMaterialPassword) {
        Configuration sslConf = new Configuration(false);
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.keystore.location"), "k_certificate");
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.keystore.password"), cryptoMaterialPassword);
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.keystore.keypassword"), cryptoMaterialPassword);
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.truststore.location"), "t_certificate");
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.truststore.password"), cryptoMaterialPassword);
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.passwordfile.location"), "material_passwd");
        Configuration sslClientConf = new Configuration(false);
        String sslClientResource = conf.get("hadoop.ssl.client.conf", "ssl-client.xml");
        sslClientConf.addResource(sslClientResource);
        long keyStoreReloadInterval = sslClientConf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.CLIENT, "ssl.{0}.keystore.reload.interval"), 10000L);
        String timeUnitStr = sslClientConf.get(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.CLIENT, "ssl.{0}.keystore.reload.timeunit"), "MILLISECONDS");
        long trustStoreReloadInterval = sslClientConf.getLong(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.CLIENT, "ssl.{0}.truststore.reload.interval"), 10000L);
        sslConf.setLong(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.keystore.reload.interval"), keyStoreReloadInterval);
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.keystore.reload.timeunit"), timeUnitStr);
        sslConf.setLong(FileBasedKeyStoresFactory.resolvePropertyName(SSLFactory.Mode.SERVER, "ssl.{0}.truststore.reload.interval"), trustStoreReloadInterval);
        return sslConf;
    }

    private static void writeSSLConf(Configuration sslConf, Configuration systemConf, File passwdFile) throws IOException {
        String filename = systemConf.get("hadoop.ssl.server.conf", "ssl-server.xml");
        String outputFile = passwdFile.getParentFile() == null ? filename : Paths.get(passwdFile.getParentFile().getAbsolutePath(), filename).toString();
        try (FileWriter fw = new FileWriter(outputFile, false);){
            sslConf.writeXml(fw);
            fw.flush();
        }
    }
}

