/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.shell.CommandWithDestination;
import org.apache.hadoop.fs.shell.PathData;

abstract class ParallelCommandWithDestination
extends CommandWithDestination {
    private ExecutorService copier;
    private ConcurrentLinkedQueue<Future> activeCopiers = new ConcurrentLinkedQueue();

    ParallelCommandWithDestination() {
    }

    @Override
    protected void processPaths(PathData parent, PathData ... items) throws IOException {
        Future future;
        for (PathData item : items) {
            ProcessPathThread processFile = new ProcessPathThread(item);
            Future f = this.getThreadProol(this.getConf()).submit(processFile);
            this.activeCopiers.add(f);
        }
        ArrayList<PathData> sucessfull = new ArrayList<PathData>();
        while ((future = this.activeCopiers.poll()) != null) {
            try {
                PathData processed = (PathData)future.get();
                sucessfull.add(processed);
            }
            catch (Exception e) {
                if (e instanceof ExecutionException) {
                    e = (Exception)e.getCause();
                }
                this.displayError(e);
            }
        }
        for (PathData item : items) {
            try {
                if (this.recursive && this.isPathRecursable(item)) {
                    this.recursePath(item);
                }
                if (!sucessfull.contains(item)) continue;
                this.postProcessPath(item);
            }
            catch (IOException e) {
                this.displayError(e);
            }
        }
    }

    protected ExecutorService getThreadProol(Configuration conf) {
        if (this.copier == null) {
            int numThreads = 1;
            if (conf != null) {
                numThreads = conf.getInt("dfs.client.copy.to.or.from.local.parallel.threads", 10);
            }
            this.copier = Executors.newFixedThreadPool(numThreads);
        }
        return this.copier;
    }

    private class ProcessPathThread
    implements Callable {
        PathData item;

        ProcessPathThread(PathData item) {
            this.item = item;
        }

        public Object call() throws Exception {
            ParallelCommandWithDestination.this.processPath(this.item);
            return this.item;
        }
    }
}

