/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SSLCertificateException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.HopsSSLTestUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.util.envVars.EnvironmentVariables;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestHopsSSLConfiguration
extends HopsSSLTestUtils {
    private final Log LOG = LogFactory.getLog(TestHopsSSLConfiguration.class);
    private final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestHopsSSLConfiguration.class.getSimpleName();
    private File baseDirFile;
    private static File classPathDir;
    @Rule
    public final ExpectedException rule = ExpectedException.none();
    Configuration conf;
    HopsSSLSocketFactory hopsFactory;
    final List<String> filesToPurge = new ArrayList<String>();

    @BeforeClass
    public static void beforeClass() throws Exception {
        classPathDir = new File(KeyStoreTestUtil.getClasspathDir(TestHopsSSLConfiguration.class));
    }

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.hopsFactory = new HopsSSLSocketFactory();
        this.baseDirFile = new File(this.BASEDIR);
        this.baseDirFile.mkdirs();
        this.filesToPurge.clear();
    }

    @After
    public void tearDown() throws IOException {
        if (this.baseDirFile.exists()) {
            FileUtils.deleteQuietly((File)this.baseDirFile);
        }
        this.purgeFiles();
        EnvironmentVariablesFactory.setInstance(null);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        File sslServerConf;
        if (classPathDir != null && (sslServerConf = Paths.get(classPathDir.getAbsolutePath(), TestHopsSSLConfiguration.class.getSimpleName() + ".ssl-server.xml").toFile()).exists()) {
            sslServerConf.delete();
        }
    }

    @Test
    public void testExistingConfIsPreserved() throws Exception {
        String hostname = NetUtils.getLocalCanonicalHostname();
        String kstore = "someDir/" + hostname + "__kstore.jks";
        String kstorePass = "somePassword";
        String keyPass = "anotherPassword";
        String tstore = "someDir/" + hostname + "__tstore.jks";
        String tstorePass = "somePassword";
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), kstore);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), kstorePass);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue(), keyPass);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), tstore);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), tstorePass);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"superuser");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)kstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)kstorePass, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)keyPass, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)tstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)tstorePass, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testWithNoConfigInTemp() throws Exception {
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.CLIENT_MATERIALIZE_DIR.getValue(), "/tmp");
        String kstore = this.touchFile("/tmp/project__user__kstore.jks");
        String tstore = this.touchFile("/tmp/project__user__tstore.jks");
        String password = "a_strong_password";
        Path passwdFile = Paths.get("/tmp", "project__user__cert.key");
        this.touchFile(passwdFile.toString());
        FileUtils.writeStringToFile((File)passwdFile.toFile(), (String)password, (boolean)false);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"project__user");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)kstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)tstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testWithNoConfigInClasspath() throws Exception {
        String cwd = System.getProperty("user.dir");
        this.touchFile(Paths.get(cwd, "k_certificate").toString());
        this.touchFile(Paths.get(cwd, "t_certificate").toString());
        String password = "a_strong_password";
        Path passwdFile = Paths.get(cwd, "material_passwd");
        this.touchFile(passwdFile.toString());
        FileUtils.writeStringToFile((File)passwdFile.toFile(), (String)"a_strong_password", (boolean)false);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"project__user");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)"k_certificate", (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)"a_strong_password", (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)"a_strong_password", (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)"t_certificate", (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)"a_strong_password", (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testBothConfigExisting() throws Exception {
        String tmp = System.getProperty("java.io.tmpdir");
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.CLIENT_MATERIALIZE_DIR.getValue(), "/tmp");
        String kstore = Paths.get(tmp, "project__user__kstore.jks").toString();
        String tstore = Paths.get(tmp, "project__user__tstore.jks").toString();
        Path passwdFile = Paths.get(tmp, "project__user__cert.key");
        String password = "a_strong_password";
        this.touchFile(kstore);
        this.touchFile(tstore);
        this.touchFile(passwdFile.toString());
        FileUtils.writeStringToFile((File)passwdFile.toFile(), (String)password, (boolean)false);
        String hostname = NetUtils.getLocalCanonicalHostname();
        String hKstore = Paths.get(tmp, hostname + "__kstore.jks").toString();
        String hTstore = Paths.get(tmp, hostname + "__tstore.jks").toString();
        this.touchFile(hKstore);
        this.touchFile(hTstore);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), "/tmp/" + hostname + "__kstore.jks");
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), "/tmp/" + hostname + "__tstore.jks");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"project__user");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)kstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)tstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testConfigurationWithMissingCertificatesNormalUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"project__user");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        this.rule.expect(SSLCertificateException.class);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
    }

    @Test
    public void testConfigurationWithMissingCertificatesSuperUser() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"superuser");
        this.createServerSSLConfig("/tmp/kstore.jks", "pass", "/tmp/tstore.jks", "pass", this.conf);
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        this.rule.expect(SSLCertificateException.class);
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
    }

    @Test
    public void testConfigurationLocalizedMaterialUserChangedCWD() throws Exception {
        File materialDir = Paths.get(this.BASEDIR, "pwd_dir").toFile();
        if (!materialDir.exists()) {
            materialDir.mkdirs();
        }
        MockEnvironmentVariablesService mockEnvService = new MockEnvironmentVariablesService();
        mockEnvService.setEnv("PWD", materialDir.getAbsolutePath());
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)mockEnvService);
        this.LOG.info((Object)("Mocked PWD is : " + EnvironmentVariablesFactory.getInstance().getEnv("PWD")));
        String keystore = Paths.get(materialDir.getAbsolutePath(), "k_certificate").toString();
        String truststore = Paths.get(materialDir.getAbsolutePath(), "t_certificate").toString();
        String passwd = Paths.get(materialDir.getAbsolutePath(), "material_passwd").toString();
        String password = "password";
        this.touchFile(keystore);
        this.touchFile(truststore);
        this.touchFile(passwd);
        FileUtils.writeStringToFile((File)new File(passwd), (String)password);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"some_user");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)keystore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)truststore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testConfigurationWithEnvironmentVariable() throws Exception {
        String user = "project__user";
        File materialDir = Paths.get(this.BASEDIR, "crypto_material").toFile();
        if (!materialDir.exists()) {
            materialDir.mkdirs();
        }
        MockEnvironmentVariablesService mockEnvService = new MockEnvironmentVariablesService();
        mockEnvService.setEnv("MATERIAL_DIRECTORY", materialDir.getAbsolutePath());
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)mockEnvService);
        String keystore = Paths.get(materialDir.getAbsolutePath(), user + "__kstore.jks").toString();
        String truststore = Paths.get(materialDir.getAbsolutePath(), user + "__tstore.jks").toString();
        String passwd = Paths.get(materialDir.getAbsolutePath(), user + "__cert.key").toString();
        String password = "some_password";
        this.touchFile(keystore);
        this.touchFile(truststore);
        this.touchFile(passwd);
        FileUtils.writeStringToFile((File)new File(passwd), (String)password, (boolean)false);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("glassfish");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Void run() throws Exception {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)keystore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)truststore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testNoConfigHostCertificates() throws Exception {
        String hostname = NetUtils.getLocalCanonicalHostname();
        String kstore = "/tmp/" + hostname + "__kstore.jks";
        String tstore = "/tmp/" + hostname + "__tstore.jks";
        this.touchFile(kstore);
        this.touchFile(tstore);
        String password = "a_strong_password";
        this.createServerSSLConfig(kstore, password, tstore, password, this.conf);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"glassfish");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("glassfish");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)kstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)tstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)password, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    private void createServerSSLConfig(String keystoreLocation, String keyStorePassword, String truststoreLocation, String trustStorePassword, Configuration conf) throws IOException {
        Configuration sslConf = KeyStoreTestUtil.createServerSSLConfig(keystoreLocation, keyStorePassword, keyStorePassword, truststoreLocation, trustStorePassword, "");
        File sslConfFile = Paths.get(classPathDir.getAbsolutePath(), TestHopsSSLConfiguration.class.getSimpleName() + ".ssl-server.xml").toFile();
        KeyStoreTestUtil.saveConfig(sslConfFile, sslConf);
        conf.set("hadoop.ssl.server.conf", TestHopsSSLConfiguration.class.getSimpleName() + ".ssl-server.xml");
    }

    @Test
    public void testHostCertificateWithSuperuser() throws Exception {
        String hostname = NetUtils.getLocalCanonicalHostname();
        String kstore = "/tmp/" + hostname + "__kstore.jks";
        String tstore = "/tmp/" + hostname + "__tstore.jks";
        String pass = "anotherPassphrase";
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), kstore);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), pass);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue(), pass);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), tstore);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), pass);
        String cwd = System.getProperty("user.dir");
        this.touchFile(Paths.get(cwd, "glassfish__kstore.jks").toString());
        this.touchFile(Paths.get(cwd, "glassfish__tstore.jks").toString());
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"glassfish");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("glassfish");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws SSLCertificateException {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Configuration factoryConf = this.hopsFactory.getConf();
        Assert.assertEquals((Object)kstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)pass, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)pass, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertEquals((Object)tstore, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertEquals((Object)pass, (Object)factoryConf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    @Test
    public void testConfigurationCloned() throws Exception {
        File materialDir = Paths.get(this.BASEDIR, "pwd_dir").toFile();
        if (!materialDir.exists()) {
            materialDir.mkdirs();
        }
        MockEnvironmentVariablesService mockEnvService = new MockEnvironmentVariablesService();
        mockEnvService.setEnv("PWD", materialDir.getAbsolutePath());
        EnvironmentVariablesFactory.setInstance((EnvironmentVariables)mockEnvService);
        this.LOG.info((Object)("Mocked PWD is : " + EnvironmentVariablesFactory.getInstance().getEnv("PWD")));
        String keystore = Paths.get(materialDir.getAbsolutePath(), "k_certificate").toString();
        String truststore = Paths.get(materialDir.getAbsolutePath(), "t_certificate").toString();
        String passwd = Paths.get(materialDir.getAbsolutePath(), "material_passwd").toString();
        String password = "password";
        this.touchFile(keystore);
        this.touchFile(truststore);
        this.touchFile(passwd);
        FileUtils.writeStringToFile((File)new File(passwd), (String)password);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"some_user");
        final HashSet<String> superusers = new HashSet<String>(1);
        superusers.add("superuser");
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                TestHopsSSLConfiguration.this.hopsFactory.setConf(TestHopsSSLConfiguration.this.conf);
                TestHopsSSLConfiguration.this.hopsFactory.configureCryptoMaterial(null, superusers);
                return null;
            }
        });
        Assert.assertNull((Object)this.conf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue()));
        Assert.assertNull((Object)this.conf.get(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue()));
        Assert.assertNull((Object)this.conf.get(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue()));
        Assert.assertNull((Object)this.conf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue()));
        Assert.assertNull((Object)this.conf.get(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue()));
    }

    private String touchFile(String file) throws IOException {
        File fd = new File(file);
        fd.createNewFile();
        this.filesToPurge.add(fd.getAbsolutePath());
        return file;
    }

    private void purgeFiles() throws IOException {
        for (String file : this.filesToPurge) {
            File f = new File(file);
            f.delete();
        }
    }

    private class MockEnvironmentVariablesService
    implements EnvironmentVariables {
        private final Map<String, String> mockEnvVars = new HashMap<String, String>();

        private MockEnvironmentVariablesService() {
        }

        private void setEnv(String variableName, String variableValue) {
            this.mockEnvVars.put(variableName, variableValue);
        }

        public String getEnv(String variableName) {
            return this.mockEnvVars.get(variableName);
        }
    }
}

