/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.log.LogLevel;
import org.apache.hadoop.net.NetUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class TestLogLevel
extends TestCase {
    static final PrintStream out = System.out;

    public void testDynamicLogLevel() throws Exception {
        String logName = TestLogLevel.class.getName();
        Log testlog = LogFactory.getLog((String)logName);
        if (testlog instanceof Log4JLogger) {
            String line;
            String line2;
            Logger log = ((Log4JLogger)testlog).getLogger();
            log.debug((Object)"log.debug1");
            log.info((Object)"log.info1");
            log.error((Object)"log.error1");
            Assert.assertNotEquals((String)"Get default Log Level which shouldn't be ERROR.", (Object)Level.ERROR, (Object)log.getEffectiveLevel());
            HttpServer2 server = new HttpServer2.Builder().setName("..").addEndpoint(new URI("http://localhost:0")).setFindPort(true).build();
            server.start();
            String authority = NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0));
            URL url = new URL("http://" + authority + "/logLevel?log=" + logName + "&level=" + Level.ERROR);
            out.println("*** Connecting to " + url);
            URLConnection connection = url.openConnection();
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line2 = in.readLine()) != null) {
                out.println(line2);
            }
            in.close();
            log.debug((Object)"log.debug2");
            log.info((Object)"log.info2");
            log.error((Object)"log.error2");
            TestLogLevel.assertEquals((String)"Try setting log level: ERROR from servlet.", (Object)Level.ERROR, (Object)log.getEffectiveLevel());
            String[] args = new String[]{"-setlevel", authority, logName, Level.DEBUG.toString()};
            LogLevel.main((String[])args);
            log.debug((Object)"log.debug3");
            log.info((Object)"log.info3");
            log.error((Object)"log.error3");
            TestLogLevel.assertEquals((String)"Try setting log level: DEBUG via command line", (Object)Level.DEBUG, (Object)log.getEffectiveLevel());
            String[] args2 = new String[]{"-setlevel", authority, logName, "Info"};
            LogLevel.main((String[])args2);
            log.debug((Object)"log.debug4");
            log.info((Object)"log.info4");
            log.error((Object)"log.error4");
            TestLogLevel.assertEquals((String)"Try setting log level: Info via command line.", (Object)Level.INFO, (Object)log.getEffectiveLevel());
            URL newUrl = new URL("http://" + authority + "/logLevel?log=" + logName + "&level=Error");
            out.println("*** Connecting to " + newUrl);
            connection = newUrl.openConnection();
            connection.connect();
            BufferedReader in2 = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in2.readLine()) != null) {
                out.println(line);
            }
            in2.close();
            log.debug((Object)"log.debug5");
            log.info((Object)"log.info5");
            log.error((Object)"log.error5");
            TestLogLevel.assertEquals((String)"Try setting log level: Error via servlet.", (Object)Level.ERROR, (Object)log.getEffectiveLevel());
        } else {
            out.println(testlog.getClass() + " not tested.");
        }
    }
}

