/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.hops.security.HopsUtil;
import io.hops.security.HopsX509AuthenticationException;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class HopsX509Authenticator {
    private static final Log LOG = LogFactory.getLog(HopsX509Authenticator.class);
    private final Configuration conf;
    private final Cache<InetAddress, String> trustedHostnames;

    HopsX509Authenticator(Configuration conf) {
        this.conf = conf;
        this.trustedHostnames = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
    }

    public void authenticateConnection(UserGroupInformation user, X509Certificate clientCertificate, InetAddress remoteAddress) throws HopsX509AuthenticationException {
        this.authenticateConnection(user, clientCertificate, remoteAddress, null);
    }

    public void authenticateConnection(UserGroupInformation user, X509Certificate clientCertificate, InetAddress remoteAddress, String protocolName) throws HopsX509AuthenticationException {
        if (!this.isHopsTLS()) {
            return;
        }
        Preconditions.checkNotNull((Object)user, (Object)"UserGroupInformation should not be null");
        Preconditions.checkNotNull((Object)clientCertificate, (Object)"Client X.509 certificate should not be null");
        LOG.debug((Object)("Authenticating user: " + user.getUserName()));
        String username = user.getUserName();
        if (username == null) {
            throw new HopsX509AuthenticationException("Could not extract username from UGI");
        }
        String subjectDN = clientCertificate.getSubjectX500Principal().getName("RFC2253");
        String cn = HopsUtil.extractCNFromSubject(subjectDN);
        if (cn == null) {
            throw new HopsX509AuthenticationException("Problematic CN in client certificate: " + subjectDN);
        }
        String org = HopsUtil.extractOFromSubject(subjectDN);
        if (org != null) {
            user.addApplicationId(org);
        }
        if (username.equals(cn)) {
            LOG.debug((Object)("Authenticated user " + username + " - Username matches CN"));
            return;
        }
        Preconditions.checkNotNull((Object)remoteAddress, (Object)"Remote address should not be null");
        String fqdn = this.isTrustedAddress(remoteAddress);
        if (fqdn != null) {
            LOG.debug((Object)("CN " + cn + " is an FQDN and it has already been authenticated"));
            return;
        }
        fqdn = remoteAddress.getCanonicalHostName();
        if (cn.equals(fqdn)) {
            this.trustedHostnames.put((Object)remoteAddress, (Object)fqdn);
            LOG.debug((Object)("CN " + cn + " is an FQDN and we managed to resolve it and it matches the remote address FQDN"));
            return;
        }
        String hostname = remoteAddress.getHostName();
        if (cn.equals(hostname)) {
            this.trustedHostnames.put((Object)remoteAddress, (Object)hostname);
            LOG.debug((Object)("CN " + cn + " is a hostname and we managed to resolve it and it matches the remote address Hostname"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not authenticate client with CN ").append(cn).append(" and username ").append(username);
        if (protocolName != null) {
            sb.append(" for protocol ").append(protocolName);
        }
        throw new HopsX509AuthenticationException(sb.toString());
    }

    private boolean isHopsTLS() {
        return this.conf.getBoolean("ipc.server.ssl.enabled", false);
    }

    @VisibleForTesting
    protected String isTrustedAddress(InetAddress address) {
        return (String)this.trustedHostnames.getIfPresent((Object)address);
    }
}

