/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.hopssslchecks;

import io.hops.security.CertificateLocalization;
import io.hops.security.HopsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.hopssslchecks.AbstractHopsSSLCheck;
import org.apache.hadoop.net.hopssslchecks.HopsSSLCryptoMaterial;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.envVars.EnvironmentVariablesFactory;

public class EnvVariableHopsSSLCheck
extends AbstractHopsSSLCheck {
    public EnvVariableHopsSSLCheck() {
        super(110);
    }

    @Override
    public HopsSSLCryptoMaterial check(UserGroupInformation ugi, Set<String> proxySuperUsers, Configuration configuration, CertificateLocalization certificateLocalization) throws IOException {
        String cryptoMaterialDir = EnvironmentVariablesFactory.getInstance().getEnv("MATERIAL_DIRECTORY");
        if (cryptoMaterialDir != null) {
            String username = ugi.getUserName();
            File keystoreFd = Paths.get(cryptoMaterialDir, username + "__kstore.jks").toFile();
            File trustStoreFd = Paths.get(cryptoMaterialDir, username + "__tstore.jks").toFile();
            File passwordFd = Paths.get(cryptoMaterialDir, username + "__cert.key").toFile();
            if (!keystoreFd.exists() || !trustStoreFd.exists()) {
                throw new IOException("Crypto material for user <" + username + "> could not be found in " + cryptoMaterialDir);
            }
            String password = HopsUtil.readCryptoMaterialPassword(passwordFd);
            return new HopsSSLCryptoMaterial(keystoreFd.getAbsolutePath(), password, password, trustStoreFd.getAbsolutePath(), password, passwordFd.getAbsolutePath(), true);
        }
        return null;
    }
}

