/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.SysInfo;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SysInfoWindows
extends SysInfo {
    private static final Log LOG = LogFactory.getLog(SysInfoWindows.class);
    private long vmemSize;
    private long memSize;
    private long vmemAvailable;
    private long memAvailable;
    private int numProcessors;
    private long cpuFrequencyKhz;
    private long cumulativeCpuTimeMs;
    private float cpuUsage;
    private long storageBytesRead;
    private long storageBytesWritten;
    private long netBytesRead;
    private long netBytesWritten;
    private long lastRefreshTime = 0L;
    static final int REFRESH_INTERVAL_MS = 1000;

    public SysInfoWindows() {
        this.reset();
    }

    @VisibleForTesting
    long now() {
        return Time.monotonicNow();
    }

    void reset() {
        this.vmemSize = -1L;
        this.memSize = -1L;
        this.vmemAvailable = -1L;
        this.memAvailable = -1L;
        this.numProcessors = -1;
        this.cpuFrequencyKhz = -1L;
        this.cumulativeCpuTimeMs = -1L;
        this.cpuUsage = -1.0f;
        this.storageBytesRead = -1L;
        this.storageBytesWritten = -1L;
        this.netBytesRead = -1L;
        this.netBytesWritten = -1L;
    }

    String getSystemInfoInfoFromShell() {
        try {
            Shell.ShellCommandExecutor shellExecutor = new Shell.ShellCommandExecutor(new String[]{Shell.getWinUtilsFile().getCanonicalPath(), "systeminfo"});
            shellExecutor.execute();
            return shellExecutor.getOutput();
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException(e));
            return null;
        }
    }

    void refreshIfNeeded() {
        long now = this.now();
        if (now - this.lastRefreshTime > 1000L) {
            long refreshInterval = now - this.lastRefreshTime;
            this.lastRefreshTime = now;
            long lastCumCpuTimeMs = this.cumulativeCpuTimeMs;
            this.reset();
            String sysInfoStr = this.getSystemInfoInfoFromShell();
            if (sysInfoStr != null) {
                int sysInfoSplitCount = 11;
                int index = sysInfoStr.indexOf("\r\n");
                if (index >= 0) {
                    String[] sysInfo = sysInfoStr.substring(0, index).split(",");
                    if (sysInfo.length == 11) {
                        try {
                            this.vmemSize = Long.parseLong(sysInfo[0]);
                            this.memSize = Long.parseLong(sysInfo[1]);
                            this.vmemAvailable = Long.parseLong(sysInfo[2]);
                            this.memAvailable = Long.parseLong(sysInfo[3]);
                            this.numProcessors = Integer.parseInt(sysInfo[4]);
                            this.cpuFrequencyKhz = Long.parseLong(sysInfo[5]);
                            this.cumulativeCpuTimeMs = Long.parseLong(sysInfo[6]);
                            this.storageBytesRead = Long.parseLong(sysInfo[7]);
                            this.storageBytesWritten = Long.parseLong(sysInfo[8]);
                            this.netBytesRead = Long.parseLong(sysInfo[9]);
                            this.netBytesWritten = Long.parseLong(sysInfo[10]);
                            if (lastCumCpuTimeMs != -1L) {
                                this.cpuUsage = (float)(this.cumulativeCpuTimeMs - lastCumCpuTimeMs) * 100.0f / (float)refreshInterval;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            LOG.warn((Object)"Error parsing sysInfo", (Throwable)nfe);
                        }
                    } else {
                        LOG.warn((Object)("Expected split length of sysInfo to be 11. Got " + sysInfo.length));
                    }
                } else {
                    LOG.warn((Object)("Wrong output from sysInfo: " + sysInfoStr));
                }
            }
        }
    }

    @Override
    public long getVirtualMemorySize() {
        this.refreshIfNeeded();
        return this.vmemSize;
    }

    @Override
    public long getPhysicalMemorySize() {
        this.refreshIfNeeded();
        return this.memSize;
    }

    @Override
    public long getAvailableVirtualMemorySize() {
        this.refreshIfNeeded();
        return this.vmemAvailable;
    }

    @Override
    public long getAvailablePhysicalMemorySize() {
        this.refreshIfNeeded();
        return this.memAvailable;
    }

    @Override
    public int getNumProcessors() {
        this.refreshIfNeeded();
        return this.numProcessors;
    }

    @Override
    public int getNumCores() {
        return this.getNumProcessors();
    }

    @Override
    public long getCpuFrequency() {
        this.refreshIfNeeded();
        return this.cpuFrequencyKhz;
    }

    @Override
    public long getCumulativeCpuTime() {
        this.refreshIfNeeded();
        return this.cumulativeCpuTimeMs;
    }

    @Override
    public float getCpuUsagePercentage() {
        this.refreshIfNeeded();
        float ret = this.cpuUsage;
        if (ret != -1.0f) {
            ret /= (float)this.numProcessors;
        }
        return ret;
    }

    @Override
    public float getNumVCoresUsed() {
        this.refreshIfNeeded();
        float ret = this.cpuUsage;
        if (ret != -1.0f) {
            ret /= 100.0f;
        }
        return ret;
    }

    @Override
    public long getNetworkBytesRead() {
        this.refreshIfNeeded();
        return this.netBytesRead;
    }

    @Override
    public long getNetworkBytesWritten() {
        this.refreshIfNeeded();
        return this.netBytesWritten;
    }

    @Override
    public long getStorageBytesRead() {
        this.refreshIfNeeded();
        return this.storageBytesRead;
    }

    @Override
    public long getStorageBytesWritten() {
        this.refreshIfNeeded();
        return this.storageBytesWritten;
    }

    public float getCpuUsage() {
        this.refreshIfNeeded();
        return this.cpuUsage;
    }

    public int getNumGPUs() {
        return 0;
    }
}

