/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenericTestUtils
extends GenericTestUtils {
    @Test
    public void testAssertExceptionContainsNullEx() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", null);
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains("Null Throwable")) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsNullString() throws Throwable {
        block2: {
            try {
                TestGenericTestUtils.assertExceptionContains("", new BrokenException());
            }
            catch (AssertionError e) {
                if (((Throwable)((Object)e)).toString().contains("Null Throwable.toString() value")) break block2;
                throw e;
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWrongText() throws Throwable {
        block3: {
            try {
                TestGenericTestUtils.assertExceptionContains("Expected", new Exception("(actual)"));
            }
            catch (AssertionError e) {
                String s = ((Throwable)((Object)e)).toString();
                if (!s.contains("but got unexpected exception") || !s.contains("(actual)")) {
                    throw e;
                }
                if (((Throwable)((Object)e)).getCause() != null) break block3;
                throw new AssertionError("No nested cause in assertion", (Throwable)((Object)e));
            }
        }
    }

    @Test
    public void testAssertExceptionContainsWorking() throws Throwable {
        TestGenericTestUtils.assertExceptionContains("Expected", new Exception("Expected"));
    }

    @Test(timeout=10000L)
    public void testLogCapturer() {
        Log log = LogFactory.getLog(TestGenericTestUtils.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(log);
        String infoMessage = "info message";
        log.info((Object)"info message");
        Assert.assertTrue((boolean)logCapturer.getOutput().endsWith(String.format("info message%n", new Object[0])));
        logCapturer.clearOutput();
        Assert.assertTrue((boolean)logCapturer.getOutput().isEmpty());
        logCapturer.stopCapturing();
        log.info((Object)"info message");
        Assert.assertTrue((boolean)logCapturer.getOutput().isEmpty());
    }

    @Test(timeout=10000L)
    public void testLogCapturerSlf4jLogger() {
        Logger logger = LoggerFactory.getLogger(TestGenericTestUtils.class);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs(logger);
        String infoMessage = "info message";
        logger.info("info message");
        Assert.assertTrue((boolean)logCapturer.getOutput().endsWith(String.format("info message%n", new Object[0])));
        logCapturer.clearOutput();
        Assert.assertTrue((boolean)logCapturer.getOutput().isEmpty());
        logCapturer.stopCapturing();
        logger.info("info message");
        Assert.assertTrue((boolean)logCapturer.getOutput().isEmpty());
    }

    private static class BrokenException
    extends Exception {
        @Override
        public String toString() {
            return null;
        }
    }
}

