/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.security.HopsX509AuthenticationException;
import io.hops.security.HopsX509Authenticator;
import io.hops.security.HopsX509AuthenticatorFactory;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestHopsX509Authenticator {
    private Configuration conf;
    private HopsX509AuthenticatorFactory authFactory;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Before
    public void before() {
        this.conf = new Configuration();
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.authFactory = HopsX509AuthenticatorFactory.getInstance((Configuration)this.conf);
    }

    @After
    public void after() {
        if (this.authFactory != null) {
            this.authFactory.clearFactory();
        }
    }

    @Test
    public void TestAuthenticatedNormalUser() throws Exception {
        String o = "application_id";
        X509Certificate clientCertificate = this.generateX509Certificate("CN=bob, O=" + o);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"bob");
        InetAddress remoteAddress = InetAddress.getLocalHost();
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertEquals((Object)o, (Object)ugi.getApplicationId());
    }

    @Test
    public void TestNotAuthenticatedNormalUser() throws Exception {
        X509Certificate clientCertificate = this.generateX509Certificate("CN=bob");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"trudy");
        InetAddress remoteAddress = InetAddress.getLocalHost();
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        this.expectedException.expect(HopsX509AuthenticationException.class);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
    }

    @Test
    public void TestAuthenticatedSuperUser() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        String o = "application_id";
        X509Certificate clientCertificate = this.generateX509Certificate("CN=" + remoteAddress.getCanonicalHostName() + ", O=" + o);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertEquals((Object)o, (Object)ugi.getApplicationId());
    }

    @Test
    public void TestNotAuthenticatedSuperUser() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        X509Certificate clientCertificate = this.generateX509Certificate("CN=i_hope_this_is_not_routable");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"chuck");
        HopsX509Authenticator authenticator = this.authFactory.getAuthenticator();
        this.expectedException.expect(HopsX509AuthenticationException.class);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
    }

    @Test
    public void TestFQDNCache() throws Exception {
        InetAddress remoteAddress = InetAddress.getLocalHost();
        X509Certificate clientCertificate = this.generateX509Certificate("CN=" + remoteAddress.getCanonicalHostName());
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"alice");
        CustomHopsX509Authenticator authenticator = new CustomHopsX509Authenticator(this.conf);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertFalse((boolean)authenticator.iscached);
        authenticator.authenticateConnection(ugi, clientCertificate, remoteAddress);
        Assert.assertTrue((boolean)authenticator.iscached);
    }

    private X509Certificate generateX509Certificate(String subjectDN) throws Exception {
        KeyPair keyPair = KeyStoreTestUtil.generateKeyPair("RSA");
        return KeyStoreTestUtil.generateCertificate(subjectDN, keyPair, 30, "SHA1withRSA");
    }

    private class CustomHopsX509Authenticator
    extends HopsX509Authenticator {
        private boolean iscached;

        CustomHopsX509Authenticator(Configuration conf) {
            super(conf);
            this.iscached = false;
        }

        protected String isTrustedAddress(InetAddress address) {
            String cachedFQDN = super.isTrustedAddress(address);
            this.iscached = cachedFQDN != null;
            return cachedFQDN;
        }
    }
}

